% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_ratings_fpi.R
\name{espn_ratings_fpi}
\alias{espn_ratings_fpi}
\title{\strong{ESPN FPI Ratings}}
\usage{
espn_ratings_fpi(year = 2019)
}
\arguments{
\item{year}{Year}
}
\value{
A data frame with 20 variables:
\describe{
\item{\code{year}: integer.}{Season of the Football Power Index (FPI) Rating.}
\item{\code{team_id}: integer.}{Unique ESPN team ID - \code{team_id}.}
\item{\code{team_name}: character.}{Team Name.}
\item{\code{team_abbreviation}: character.}{Team abbreviation.}
\item{\code{fpi}: character.}{Football Power Index (FPI) Rating.}
\item{\code{fpi_rk}: character.}{Football Power Index (FPI) Rank.}
\item{\code{trend}: character.}{Football Power Index (FPI) ranking trend.}
\item{\code{projected_wins}: character.}{Projected Win total for the season.}
\item{\code{projected_losses}: character.}{Projected Loss total for the season.}
\item{\code{win_out_pct}: double.}{Probability the team wins out.}
\item{\code{win_6_pct}: double.}{Probability the team wins at least six games.}
\item{\code{win_division_pct}: double.}{Probability the team wins at their division.}
\item{\code{playoff_pct}: double.}{Probability the team reaches the playoff.}
\item{\code{nc_game_pct}: double.}{Probability the team reaches the national championship game.}
\item{\code{nc_win_pct}: double.}{Probability the team wins the national championship game.}
\item{\code{win_conference_pct}: double.}{Probability the team wins their conference game.}
\item{\code{w}: integer.}{Wins on the season.}
\item{\code{l}: integer.}{Losses on the season.}
\item{\code{t}: character.}{Ties on the season.}
}
}
\description{
Get FPI historical rating data (most recent of each year)
}
\details{
Adapted from sabinanalytic's fork of the cfbfastR repo
}
\examples{
\donttest{
  try(espn_ratings_fpi(year=2019))
}
}
\keyword{FPI}
\keyword{Ratings}
