% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charisma-package.R
\docType{package}
\name{charisma-package}
\alias{charisma-package}
\title{charisma: Reproducible Color Characterization of Digital Images for Biological Studies}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Provides a standardized and reproducible framework for characterizing and classifying discrete color classes from digital images of biological organisms. The package automatically determines the presence or absence of 10 human-visible color categories (black, blue, brown, green, grey, orange, purple, red, white, yellow) using a biologically-inspired Color Look-Up Table (CLUT) that partitions HSV color space. Supports both fully automated and semi-automated (interactive) workflows with complete provenance tracking for reproducibility. Pre-processes images using the 'recolorize' package (Weller et al. 2024 \doi{10.1111/ele.14378}) for spatial-color binning, and integrates with 'pavo' (Maia et al. 2019 \doi{10.1111/2041-210X.13174}) for color pattern geometry statistics. Designed for high-throughput analysis and seamless integration with downstream evolutionary analyses.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/shawntz/charisma}
  \item \url{https://shawnschwartz.com/charisma/}
  \item Report bugs at \url{https://github.com/shawntz/charisma/issues}
}

}
\author{
\strong{Maintainer}: Shawn Schwartz \email{shawn.t.schwartz@gmail.com} (\href{https://orcid.org/0000-0001-6444-8451}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Whitney Tsai \email{wtsai@nhm.org} (\href{https://orcid.org/0000-0003-3274-2829}{ORCID})
  \item Elizabeth Karan (\href{https://orcid.org/0000-0003-1942-0307}{ORCID})
  \item Mark Juhn
  \item Allison Shultz \email{ashultz@nhm.org} (\href{https://orcid.org/0000-0002-2089-4086}{ORCID})
  \item John McCormack (\href{https://orcid.org/0000-0002-0912-1461}{ORCID})
  \item Thomas Smith (\href{https://orcid.org/0000-0002-5978-6912}{ORCID})
  \item Michael Alfaro \email{michaelalfaro@g.ucla.edu} (\href{https://orcid.org/0000-0002-8898-8230}{ORCID})
}

}
\keyword{internal}
