% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy-provider.R
\name{TaxonomyProvider}
\alias{TaxonomyProvider}
\title{TaxonomyProvider}
\description{
Taxonomy provider for Generating Taxonomic names.
}
\section{Names}{

Names were taken from Theplantlist. 500 genera names and 500
epithets were chosen at random from the set of 10,000 names in the
dataset in the \code{taxize} package. Theplantlist is, as it says on the
tin, composed of plant names - so these fake names are derived from
plant names if that matters to you. These may generate names that match
those of real taxa, but may not as well.
}

\section{Taxonomic authority}{

Randomly, the taxonomic authority is in parentheses - which represents
that the given authority was not the original authority.
}

\seealso{
Other ParentProviders: 
\code{\link{AddressProvider}},
\code{\link{ColorProvider}},
\code{\link{CompanyProvider}},
\code{\link{InternetProvider}},
\code{\link{JobProvider}},
\code{\link{LoremProvider}},
\code{\link{PersonProvider}},
\code{\link{PhoneNumberProvider}},
\code{\link{UserAgentProvider}}
}
\concept{ParentProviders}
\section{Super classes}{
\code{\link[charlatan:BareProvider]{charlatan::BareProvider}} -> \code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{TaxonomyProvider}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TaxonomyProvider-genus}{\code{TaxonomyProvider$genus()}}
\item \href{#method-TaxonomyProvider-epithet}{\code{TaxonomyProvider$epithet()}}
\item \href{#method-TaxonomyProvider-species}{\code{TaxonomyProvider$species()}}
\item \href{#method-TaxonomyProvider-new}{\code{TaxonomyProvider$new()}}
\item \href{#method-TaxonomyProvider-clone}{\code{TaxonomyProvider$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="bothify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-bothify'><code>charlatan::BareProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="lexify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-lexify'><code>charlatan::BareProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="numerify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-numerify'><code>charlatan::BareProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit'><code>charlatan::BareProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero'><code>charlatan::BareProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero_or_empty'><code>charlatan::BareProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_or_empty'><code>charlatan::BareProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element'><code>charlatan::BareProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element_prob"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element_prob'><code>charlatan::BareProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_int"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_int'><code>charlatan::BareProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_letter"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_letter'><code>charlatan::BareProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-randomize_nb_elements'><code>charlatan::BareProvider$randomize_nb_elements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="allowed_locales"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-allowed_locales'><code>charlatan::BaseProvider$allowed_locales()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="print"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-print'><code>charlatan::BaseProvider$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaxonomyProvider-genus"></a>}}
\if{latex}{\out{\hypertarget{method-TaxonomyProvider-genus}{}}}
\subsection{Method \code{genus()}}{
Get a genus name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaxonomyProvider$genus()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaxonomyProvider-epithet"></a>}}
\if{latex}{\out{\hypertarget{method-TaxonomyProvider-epithet}{}}}
\subsection{Method \code{epithet()}}{
Get an epithet name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaxonomyProvider$epithet()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaxonomyProvider-species"></a>}}
\if{latex}{\out{\hypertarget{method-TaxonomyProvider-species}{}}}
\subsection{Method \code{species()}}{
Get a binomial name (genus + epithet)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaxonomyProvider$species(authority = FALSE, date = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{authority}}{Include authority. default: \code{FALSE}}

\item{\code{date}}{Include authority date. If \code{authority = FALSE},
this is ignored. default: \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaxonomyProvider-new"></a>}}
\if{latex}{\out{\hypertarget{method-TaxonomyProvider-new}{}}}
\subsection{Method \code{new()}}{
Initialize new Taxonomy Provider.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaxonomyProvider$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TaxonomyProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TaxonomyProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaxonomyProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
