% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DifyChat4R.R
\name{DifyChat4R}
\alias{DifyChat4R}
\title{DifyChat4R Function (Completion Messages Only)}
\usage{
DifyChat4R(
  query,
  user = "abc-123",
  api_key = Sys.getenv("DIFY_API_KEY"),
  conversation_id = "",
  files = NULL
)
}
\arguments{
\item{query}{A character string representing the user's input query.}

\item{user}{A character string representing the user identifier. Default is "abc-123".}

\item{api_key}{A character string for the Dify API secret key.
Defaults to the value of the environment variable "DIFY_API_KEY".}

\item{conversation_id}{A character string representing the conversation ID. Default is an empty string.}

\item{files}{A list of lists representing file information to be sent with the query. Default is NULL.
Each file should be a list containing at least the keys:
  - type (e.g., "image")
  - transfer_method (e.g., "remote_url")
  - url (the file URL)}
}
\value{
A list containing the parsed JSON response from the Dify API.
}
\description{
This function sends a query to the Dify API using the completion-messages endpoint in blocking mode.
It provides a simple interface for interacting with Dify AI applications.
The function uses the stable blocking response mode to avoid streaming parsing issues.
}
\examples{
\dontrun{
  # Set your Dify API key in the environment or pass it directly
  Sys.setenv(DIFY_API_KEY = "YOUR-DIFY-SECRET-KEY")

  # Basic usage
  response <- DifyChat4R(query = "Hello world!")
  print(response)

  # With conversation context
  response <- DifyChat4R(
    query = "How are you?",
    conversation_id = "conv-123",
    user = "user-456"
  )
  print(response)
}

}
