% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCommentCode.R
\name{addCommentCode}
\alias{addCommentCode}
\title{Add Comments to R Code}
\usage{
addCommentCode(
  Model = "gpt-4o-mini",
  language = "English",
  SelectedCode = TRUE,
  provider = "auto"
)
}
\arguments{
\item{Model}{A character string specifying the model to be used. Default is "gpt-4o-mini" for OpenAI or "gemini-2.0-flash" for Gemini.}

\item{language}{A character string specifying the language for the comments. Default is "English".}

\item{SelectedCode}{A logical value indicating whether to use the selected code in RStudio. Default is TRUE.}

\item{provider}{A character string specifying the API provider. Options: "auto" (default), "openai", "gemini". When "auto", automatically detects available API keys with priority: OpenAI → Gemini.}
}
\value{
A message indicating completion if `SelectedCode` is TRUE, otherwise the commented code is copied to the clipboard.
}
\description{
This function adds comments to R code without modifying the input R code.
   It can either take the selected code from RStudio or read from the clipboard.
}
\details{
Add Comments to R Code
}
\examples{
\dontrun{
# Option 1: Auto-detect available API (OpenAI or Gemini)
# Select some text in RStudio and then run the rstudio addins
addCommentCode(Model = "gpt-4o-mini", language = "English", SelectedCode = TRUE)

# Option 2: Explicitly use OpenAI
addCommentCode(Model = "gpt-4o-mini", provider = "openai", SelectedCode = TRUE)

# Option 3: Use Gemini API
addCommentCode(Model = "gemini-2.0-flash", provider = "gemini", SelectedCode = TRUE)

# Option 4: Copy text to clipboard and execute
addCommentCode(Model = "gpt-4o-mini", language = "English", SelectedCode = FALSE)
}
}
\author{
Satoshi Kume
}
