% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiLLMviaionet.R
\name{refresh_ionet_models}
\alias{refresh_ionet_models}
\title{refresh_ionet_models: Manually refresh the cached model list from io.net API}
\usage{
refresh_ionet_models(api_key = NULL, verbose = TRUE)
}
\arguments{
\item{api_key}{Optional API key for fetching current models. Defaults to IONET_API_KEY environment variable.}

\item{verbose}{Logical indicating whether to show detailed fetching information. Default is TRUE.}
}
\value{
A character vector of current model names from the API, or NULL if the API call failed
}
\description{
This function forces a refresh of the model list cache by fetching
  the current models from the io.net API. Use this if you suspect the model list
  has changed and you want to update immediately rather than waiting for the
  1-hour cache to expire.
}
\details{
Refresh io.net Model Cache
}
\examples{
\dontrun{
  # Refresh model list from API
  current_models <- refresh_ionet_models()

  # Refresh silently
  current_models <- refresh_ionet_models(verbose = FALSE)
}
}
\author{
Satoshi Kume
}
