% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env_gcms.R
\name{env_gcms}
\alias{env_gcms}
\title{General Circulation Model (GCM) Environmental Distribution}
\usage{
env_gcms(
  s,
  var_names = c("bio_1", "bio_12"),
  study_area = NULL,
  highlight = "sum",
  resolution = 25,
  title = NULL
)
}
\arguments{
\item{s}{A list of stacks of General Circulation Models (GCMs).}

\item{var_names}{Character. A vector of names of the variables to include, or 'all' to include all variables.}

\item{study_area}{An Extent object, or any object from which an Extent object can be extracted. Defines the study area for cropping and masking the rasters.}

\item{highlight}{Character. A vector of GCM names to be highlighted. All other GCMs will appear in grey.}

\item{resolution}{Numeric. The resolution to be used in the plot. Default is \code{25}.}

\item{title}{Character. The title of the plot.}
}
\value{
A plot displaying the environmental space for the specified GCMs.
}
\description{
This function visualizes GCM data in environmental space, with options to highlight clusters or specific GCMs.
}
\examples{
var_names <- c("bio_1", "bio_12")
s <- import_gcms(system.file("extdata", package = "chooseGCM"), var_names = var_names)[1:5]
study_area <- terra::ext(c(-80, -70, -50, -40)) |>
  terra::vect(crs="+proj=longlat +datum=WGS84 +no_defs")
env_gcms(s, var_names, study_area, highlight = c("ae", "ch", "cr"))

}
\seealso{
\code{\link{summary_gcms}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
