% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_NA_with_label.R
\name{replace_NA_with_label}
\alias{replace_NA_with_label}
\title{Replace \code{NA} values in dlabel \code{"xifti"} with a new label.}
\usage{
replace_NA_with_label(
  xifti,
  NA_value = NULL,
  NA_label = "NA",
  NA_color = "#FFFFFFFF",
  idx = NULL
)
}
\arguments{
\item{xifti}{The \code{"xifti"}}

\item{NA_value}{The new label value for \code{NA} values. If \code{NULL}
(default), use -1 if all existing label values are non-negative, otherwise
use one less than the minimum existing label value.}

\item{NA_label}{The new label name for \code{NA} values. Default: \code{"NA"}.}

\item{NA_color}{The new label color for \code{NA} values, as a hex code with
alpha. Default: \code{"#FFFFFFFF"}.}

\item{idx}{Numeric vector indicating the \code{"xifti"} columns to add
\code{NA} labels for. Default: \code{NULL} (add to all columns).}
}
\value{
\code{xifti} with a new label value for \code{NA} values
}
\description{
\code{NaN} values will be converted to \code{NA} and also replaced.
}
\keyword{internal}
