% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle.R
\name{circle}
\alias{circle}
\title{Circle CI HTTP Requests}
\usage{
circle(
  verb = "GET",
  path = "",
  query = list(),
  body = "",
  api_version = "v2",
  encode = "json"
)
}
\arguments{
\item{verb}{\verb{[character]}\cr
A character string containing an HTTP verb, defaulting to \code{GET}.}

\item{path}{\verb{[character]}\cr
A character string with the API endpoint (should begin with a slash).}

\item{query}{\verb{[character]}\cr
A list specifying any query string arguments to pass to the API.
This is used to pass the API token.}

\item{body}{\verb{[character]}\cr
A named list or array of what should be passed in the
request.
Corresponds to the "-d" argument of the \code{curl} command.}

\item{api_version}{\verb{[character]}\cr
A character string specifying the Circle CI API version.
This usually does not need to be changed by the user.}

\item{encode}{\verb{[character]}\cr
Encoding format. See \link[httr:POST]{httr::POST}.}
}
\value{
An object of class \code{circle_api} with the following elements
\itemize{
\item \code{content} (queried content)
\item \code{path} (API request)
\item \code{response} (HTTP response information)
}
}
\description{
Workhorse function for executing API requests to
Circle CI.
}
\details{
In almost all cases, users should not need to execute API calls
directly. However, if desired this functions makes it possible to issue
any API request. If you experience calling a custom request heavily,
consider opening a feature request on GitHub.
}
\examples{
\dontrun{
circle(verb = "GET", path = "/project/gh/ropensci/circle/checkout-key")
}
}
