% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-and-coerce.R
\name{cld_methods}
\alias{cld_methods}
\alias{print.cld_object}
\alias{as.data.frame.cld_object}
\alias{as.character.cld_object}
\alias{as_tibble.cld_object}
\title{Print and coercion methods for cld_object}
\usage{
\method{print}{cld_object}(x, ...)

\method{as.data.frame}{cld_object}(x, ...)

\method{as.character}{cld_object}(x, ...)

\method{as_tibble}{cld_object}(x, ...)
}
\arguments{
\item{x}{A \code{cld_object} to print or convert}

\item{...}{Additional arguments passed to print methods}
}
\value{
\itemize{
\item \code{print.cld_object()}: Invisibly returns the input object
\item \code{as.data.frame.cld_object()}: Returns a plain data frame
\item \code{as.character.cld_object()}: Returns a named character vector of letters
\item \code{as_tibble.cld_object()}: Returns a tibble
}
}
\description{
Print and coercion methods for cld_object
}
\examples{
obj <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)
result <- make_cld(obj)

# Print method
print(result)

# Convert to plain data frame
as.data.frame(result)

# Convert to named character vector
as.character(result)

# Convert to tibble
if (requireNamespace("tibble", quietly = TRUE)) {
  tibble::as_tibble(result)
}
}
\seealso{
\itemize{
\item \code{\link[=make_cld]{make_cld()}} for creating compact letter displays
\item \code{\link[=as_cld]{as_cld()}} for converting objects to cld_object
}
}
\concept{cld_object methods}
\concept{cld_object_methods}
\concept{output methods}
\concept{output_methods}
\keyword{print}
