% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_dates.R
\name{date_guess}
\alias{date_guess}
\title{Try and guess dates from a characters}
\usage{
date_guess(x, column_name, quiet = TRUE, orders = NULL)
}
\arguments{
\item{x}{A \code{<vector>} of characters or factors}

\item{column_name}{A \code{<character>} with the target column name}

\item{quiet}{A \code{<logical>} indicating if messages should be displayed to
the console. Default is \code{TRUE}; set to \code{FALSE} to silence
messages}

\item{orders}{A \code{<list>} or \code{<vector>} of characters with the date
codes for fine-grained parsing of dates. This allows for parsing of mixed
dates. If a \code{<list>} is supplied, that \code{<list>} will be used for
successive tries in parsing. When this is not provided
(\code{orders = NULL}), the function will use the following order defined
in the guesser:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
  quarter_partial_dates = c("Y", "Ym", "Yq"),
  world_digit_months = c("Yq", "ymd", "ydm", "dmy", "mdy", "myd", "dym",
                         "Ymd", "Ydm", "dmY", "mdY", "mYd", "dYm"),
  world_named_months = c("dby", "dyb", "bdy", "byd", "ybd", "ydb",
                         "dbY", "dYb", "bdY", "bYd", "Ybd", "Ydb"),
  us_format = c("Omdy", "YOmd")
)
}\if{html}{\out{</div>}}}
}
\value{
A \code{<list>} of following three elements: a vector of the newly
reformatted dates, a data frame with the date values that were converted
based on more than one format, and a Boolean that specifies whether
ambiguous values were found or not. If all values comply with only one
format, the second element will be NULL.
}
\description{
Note that THIS FEATURE IS STILL EXPERIMENTAL: we strongly recommend checking
a few converted dates manually. This function tries to extract dates from a
\code{character} vector or a \code{factor}. It treats each entry independently, using
regular expressions to detect if a date is present, its format, and if
successful it converts that entry to a standard \code{Date} with the \emph{Ymd} format
(e.g. \code{2018-01-21}). Entries which cannot be processed result in \code{NA}. An
error threshold can be used to define the maximum number of resulting \code{NA}
(i.e. entries without an identified date) that can be tolerated. If this
threshold is exceeded, the original vector is returned.
}
\keyword{internal}
