% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_summary_report.R
\name{generate_summary_report}
\alias{generate_summary_report}
\title{Generate a Summary Report of Dataset Comparison}
\usage{
generate_summary_report(
  comparison_results,
  detail_level = "high",
  output_format = "text",
  file_name = NULL
)
}
\arguments{
\item{comparison_results}{A list containing the results of dataset comparisons.}

\item{detail_level}{The level of detail ('high', 'medium', 'low') for the summary.}

\item{output_format}{Format of the output ('text' or 'html').}

\item{file_name}{Name of the file to save the report to (applicable for 'html' format).}
}
\value{
The summary report. For 'text', prints to console. For 'html', writes to file.
}
\description{
Provides a summary of the comparison results, highlighting key points such as the number of differing observations and variables.
}
\examples{
\dontrun{
  generate_summary_report(comparison_results, detail_level = "high", output_format = "text")
}
}
