\name{aap_pediatric_htn_guidelines}
\alias{aap_pediatric_htn_guidelines}
\title{
AAP Pediatric Hypertension Guidelines (2017)
}
\description{
Classifies blood pressure in children and adolescents according to the 2017 American Academy of Pediatrics (AAP) Clinical Practice Guideline.

The function handles two age groups:
1. Adolescents (>= 13 years): Uses static absolute cutoffs matching adult guidelines (Normal, Elevated, Stage 1, Stage 2).
2. Children (1 to <13 years): Uses percentile-based logic. Note: Users must provide the child-specific 90th and 95th percentile BP thresholds (based on age, sex, and height) as arguments.
}
\usage{
aap_pediatric_htn_guidelines(age, systolic, diastolic,
                             sbp_90th = NULL, sbp_95th = NULL,
                             dbp_90th = NULL, dbp_95th = NULL)
}
\arguments{
  \item{age}{
Numeric. Age of the patient in years.
}
  \item{systolic}{
Numeric. Measured systolic blood pressure (mmHg).
}
  \item{diastolic}{
Numeric. Measured diastolic blood pressure (mmHg).
}
  \item{sbp_90th}{
Numeric (Required for age < 13). The 90th percentile Systolic BP for the child's sex, age, and height.
}
  \item{sbp_95th}{
Numeric (Required for age < 13). The 95th percentile Systolic BP for the child's sex, age, and height.
}
  \item{dbp_90th}{
Numeric (Required for age < 13). The 90th percentile Diastolic BP for the child's sex, age, and height.
}
  \item{dbp_95th}{
Numeric (Required for age < 13). The 95th percentile Diastolic BP for the child's sex, age, and height.
}
}
\value{
A list containing:
\item{Classification}{The BP category (Normal, Elevated, Stage 1, or Stage 2).}
\item{Management_Recommendation}{Suggested follow-up actions based on the 2017 AAP CPG.}
\item{Applied_Criteria}{Indicates whether adult (static) or pediatric (percentile) logic was used.}
}
\references{
Flynn JT, Kaelber DC, Baker-Smith CM, et al. Clinical Practice Guideline for Screening and Management of High Blood Pressure in Children and Adolescents. Pediatrics. 2017;140(3):e20171904. doi:10.1542/peds.2017-1904
}
\examples{

# Example 1: Adolescent (14 years old) - Static Cutoffs
# BP 132/82 -> Stage 1 Hypertension
aap_pediatric_htn_guidelines(age = 14, systolic = 132, diastolic = 82)

# Example 2: Child (8 years old) - Percentile Based
# Measured: 112/60 -> Stage 1 (SBP > 95th)
aap_pediatric_htn_guidelines(
  age = 8, systolic = 112, diastolic = 60,
  sbp_90th = 105, sbp_95th = 109,
  dbp_90th = 65, dbp_95th = 69
)
}
