\name{absolute_lymphocyte_count}
\alias{absolute_lymphocyte_count}
\title{
Absolute Lymphocyte Count (ALC)
}
\description{
Calculates the Absolute Lymphocyte Count (ALC) based on the total White Blood Cell (WBC) count and the percentage of lymphocytes from a differential blood count. ALC is a useful marker for immune function and is used in the monitoring of HIV/AIDS, post-transplant patients, and chemotherapy (e.g., assessing susceptibility to opportunistic infections).
}
\usage{
absolute_lymphocyte_count(wbc, lymphs_percent)
}
\arguments{
  \item{wbc}{
Numeric. The total White Blood Cell count. Can be entered as cells/microL (e.g., 5000) or k/microL (e.g., 5.0). The output unit will match the input magnitude.
}
  \item{lymphs_percent}{
Numeric. The percentage of lymphocytes reported in the WBC differential (0-100).
}
}
\value{
A list containing:
\item{ALC}{The calculated Absolute Lymphocyte Count in the same unit scale as the WBC input.}
\item{Interpretation}{General classification (Lymphopenia < 1000 cells/microL, Lymphocytosis > 4000 cells/microL). The function attempts to detect if inputs were in k/microL for interpretation purposes.}
}
\references{
Al-Gwaiz LA, Babay HH. The diagnostic value of absolute lymphocyte count in typhoid fever. J Infect Dev Ctries. 2007;1(3):260-265.
}
\examples{

# Example 1: Normal
# WBC 6000 cells/uL, 30\% Lymphs
absolute_lymphocyte_count(6000, 30)

# Example 2: Lymphopenia (using k/uL input)
# WBC 3.5 k/uL, 15\% Lymphs
# Result will be 0.525 k/uL (which is 525 cells/uL -> Lymphopenia)
absolute_lymphocyte_count(3.5, 15)
}
