\name{aortic_dissection_detection_risk_score}
\alias{aortic_dissection_detection_risk_score}
\title{
Aortic Dissection Detection Risk Score (ADD-RS)
}
\description{
Calculates the ADD-RS to stratify the pre-test probability of acute aortic dissection. The score is based on the presence of features in three categories: Predisposing Conditions, Pain Features, and Physical Exam Findings. The presence of any feature in a category awards 1 point, for a maximum score of 3.
}
\usage{
aortic_dissection_detection_risk_score(high_risk_conditions,
high_risk_pain, high_risk_exam)
}
\arguments{
  \item{high_risk_conditions}{
Numeric (0 or 1). Presence of any high-risk condition: Marfan syndrome, connective tissue disease, family history of aortic disease, known aortic valve disease, recent aortic manipulation, or known thoracic aortic aneurysm. (1 = Present).
}
  \item{high_risk_pain}{
Numeric (0 or 1). Presence of any high-risk pain feature: Abrupt onset, severe intensity, or ripping/tearing sensation. (1 = Present).
}
  \item{high_risk_exam}{
Numeric (0 or 1). Presence of any high-risk exam feature: Pulse deficit, systolic BP differential, focal neurological deficit (with pain), new aortic insufficiency murmur, or hypotension/shock. (1 = Present).
}
}
\value{
A list containing:
\item{ADD_RS_Score}{The calculated score (Range 0-3).}
\item{Risk_Category}{Risk classification (Low = 0, Moderate = 1, High = 2-3).}
\item{Recommendation}{Guidance on workup (D-dimer vs. Imaging) based on AHA/ACC guidelines.}
}
\references{
Rogers AM, Hermann LK, Booher AM, et al. Sensitivity of the aortic dissection detection risk score, a novel guideline-based tool for identification of acute aortic dissection at initial presentation: results from the international registry of acute aortic dissection. Circulation. 2011;123(20):2213-2218. doi:10.1161/CIRCULATIONAHA.110.988568
}
\examples{

# Example 1: High Risk
# Patient with Marfan syndrome (Conditions=1) and Ripping chest pain (Pain=1)
aortic_dissection_detection_risk_score(1, 1, 0)

# Example 2: Low Risk
# No high risk features present
aortic_dissection_detection_risk_score(0, 0, 0)
}
