\name{ascod_stroke_phenotype}
\alias{ascod_stroke_phenotype}
\title{
ASCOD Phenotyping for Ischemic Stroke
}
\description{
Generates the ASCOD phenotype string for ischemic stroke characterization. The ASCOD classification system characterizes stroke based on the presence and likelihood of five underlying pathologies: Atherosclerosis (A), Small vessel disease (S), Cardiac pathology (C), Other causes (O), and Dissection (D). Each category is graded based on the strength of the causal link.
}
\usage{
ascod_stroke_phenotype(a_grade, s_grade, c_grade, o_grade, d_grade)
}
\arguments{
  \item{a_grade}{
Numeric (0, 1, 2, 3, or 9). Grade for Atherosclerosis.
}
  \item{s_grade}{
Numeric (0, 1, 2, 3, or 9). Grade for Small Vessel Disease.
}
  \item{c_grade}{
Numeric (0, 1, 2, 3, or 9). Grade for Cardiac Pathology.
}
  \item{o_grade}{
Numeric (0, 1, 2, 3, or 9). Grade for Other Causes.
}
  \item{d_grade}{
Numeric (0, 1, 2, 3, or 9). Grade for Dissection.
}
}
\details{
\strong{Grading Key:}
1: Potential Cause (Disease present and potentially causal).
2: Uncertain Cause (Disease present but causal link uncertain).
3: Unlikely Cause (Disease present but unlikely to be the cause).
0: Absent (No disease found).
9: Insufficient Workup (Grading not possible).
}
\value{
A list containing:
\item{ASCOD_Phenotype}{The formatted phenotype string (e.g., "A1-S3-C0-O9-D0").}
\item{Interpretation}{A breakdown of the clinical significance for each category.}
}
\references{
Amarenco P, Bogousslavsky J, Caplan LR, Donnan GA, Hennerici MG. The ASCOD phenotyping of ischemic stroke (Updated ASCOD I). Cerebrovasc Dis. 2013;36(1):1-5. doi:10.1159/000352050
}
\examples{

# Example 1: Cardioembolic Stroke
# Atherosclerosis absent (0), Small vessel unlikely (3),
# Cardiac potential (1), Other insuff (9), Dissection absent (0)
ascod_stroke_phenotype(0, 3, 1, 9, 0)

# Example 2: Mixed Etiology
# Atherosclerosis potential (1), Small vessel potential (1), others absent
ascod_stroke_phenotype(1, 1, 0, 0, 0)
}
