\name{atria_bleeding_risk}
\alias{atria_bleeding_risk}
\title{
ATRIA Bleeding Risk Score
}
\description{
Calculates the ATRIA (Anticoagulation and Risk Factors in Atrial Fibrillation) Bleeding Risk Score. This tool stratifies the risk of major hemorrhage in patients with atrial fibrillation who are taking warfarin. It outperforms the HAS-BLED score in predicting major bleeding events.
}
\usage{
atria_bleeding_risk(age, sex, hemoglobin_g_dl, egfr_ml_min, prior_bleeding, hypertension)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 75 years adds +2 points).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). Used to define anemia thresholds.
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL. Anemia (<13 g/dL in men, <12 g/dL in women) adds +3 points.
}
  \item{egfr_ml_min}{
Numeric. Estimated Glomerular Filtration Rate (eGFR) in mL/min/1.73m^2. Severe renal disease (<30 mL/min) adds +3 points.
}
  \item{prior_bleeding}{
Numeric (0 or 1). History of prior hemorrhage diagnosis. (1 = Yes, +1 point).
}
  \item{hypertension}{
Numeric (0 or 1). History of hypertension. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{ATRIA_Score}{The calculated risk score (Range 0-10).}
\item{Risk_Category}{Classification (Low: 0-3, Intermediate: 4, High: >4).}
\item{Annual_Major_Bleeding_Risk}{Estimated annual rate of major hemorrhage.}
}
\references{
Fang MC, Go AS, Chang Y, et al. A new risk scheme to predict warfarin-associated hemorrhage: The ATRIA (Anticoagulation and Risk Factors in Atrial Fibrillation) Study. J Am Coll Cardiol. 2011;58(4):395-401. doi:10.1016/j.jacc.2011.03.031
}
\examples{

# Example 1: High Risk
# 80yo Male (+2), Hgb 11 (+3), eGFR 25 (+3), No Bleed, HTN (+1)
# Score = 9
atria_bleeding_risk(80, "male", 11, 25, 0, 1)

# Example 2: Low Risk
# 65yo Female (0), Hgb 13 (0), eGFR 60 (0), No Bleed, No HTN
# Score = 0
atria_bleeding_risk(65, "female", 13, 60, 0, 0)
}
