\name{benzodiazepine_conversion}
\alias{benzodiazepine_conversion}
\title{
Benzodiazepine Conversion Calculator
}
\description{
Calculates the estimated equivalent dose between different benzodiazepines. The calculation typically uses 10 mg of oral Diazepam as the standard reference unit to derive equivalencies for other agents (e.g., based on the Ashton Manual and other clinical pharmacological data).
}
\usage{
benzodiazepine_conversion(source_drug, source_dose, target_drug)
}
\arguments{
  \item{source_drug}{
String. The name of the benzodiazepine currently being taken. Options: "alprazolam", "chlordiazepoxide", "clobazam", "clonazepam", "clorazepate", "diazepam", "estazolam", "flurazepam", "lorazepam", "midazolam_oral", "midazolam_iv", "nitrazepam", "oxazepam", "quazepam", "temazepam", "triazolam".
}
  \item{source_dose}{
Numeric. The dose of the source drug in milligrams (mg).
}
  \item{target_drug}{
String. The name of the benzodiazepine to convert to. (Same options as source_drug).
}
}
\value{
A list containing:
\item{Input}{The provided source drug and dose.}
\item{Output}{The calculated equivalent dose of the target drug.}
\item{Diazepam_Equivalent_mg}{The calculated dose standardized to oral Diazepam.}
\item{Note}{Clinical warning regarding cross-tolerance and variability.}
}
\references{
Ashton H. Protocol for the treatment of benzodiazepine withdrawal. University of Newcastle upon Tyne. 2002.
}
\examples{

# Example 1: Convert 1mg Alprazolam to Diazepam
# 0.5mg Alprazolam ~= 10mg Diazepam, so 1mg ~= 20mg
benzodiazepine_conversion("alprazolam", 1, "diazepam")

# Example 2: Convert 2mg Lorazepam to Clonazepam
# 1mg Lorazepam ~= 0.5mg Clonazepam, so 2mg ~= 1mg
benzodiazepine_conversion("lorazepam", 2, "clonazepam")
}
