\name{caspar_psoriatic_arthritis}
\alias{caspar_psoriatic_arthritis}
\title{
CASPAR Criteria for Psoriatic Arthritis
}
\description{
Calculates the CASPAR (ClASsification criteria for Psoriatic ARthritis) score. These criteria are intended for patients with inflammatory articular disease (joint, spine, or entheseal). A score of 3 or greater has high sensitivity (91.4\%) and specificity (98.7\%) for the diagnosis of Psoriatic Arthritis.
}
\usage{
caspar_psoriatic_arthritis(inflammatory_disease_present, current_psoriasis,
                           personal_history_psoriasis, family_history_psoriasis,
                           nail_dystrophy, negative_rf, dactylitis,
                           juxta_articular_bone_formation)
}
\arguments{
  \item{inflammatory_disease_present}{
Numeric (0 or 1). Entry Criterion: Does the patient have inflammatory articular disease (joint, spine, or entheseal)? (1 = Yes).
}
  \item{current_psoriasis}{
Numeric (0 or 1). Current psoriatic skin or scalp disease present as judged by a rheumatologist or dermatologist. (1 = Yes, +2 points).
}
  \item{personal_history_psoriasis}{
Numeric (0 or 1). A history of psoriasis that may be obtained from patient, family physician, dermatologist, rheumatologist, or other qualified health care provider. (1 = Yes, +1 point). Note: Only scored if Current Psoriasis is No.
}
  \item{family_history_psoriasis}{
Numeric (0 or 1). A history of psoriasis in a first- or second-degree relative according to patient report. (1 = Yes, +1 point). Note: Only scored if Current and Personal History are No.
}
  \item{nail_dystrophy}{
Numeric (0 or 1). Typical psoriatic nail dystrophy including onycholysis, pitting, and hyperkeratosis observed on current physical examination. (1 = Yes, +1 point).
}
  \item{negative_rf}{
Numeric (0 or 1). A negative test for rheumatoid factor by any method except latex but preferably by ELISA or nephelometry. (1 = Yes, +1 point).
}
  \item{dactylitis}{
Numeric (0 or 1). Swelling of an entire digit (dactylitis); present or recorded by a rheumatologist. (1 = Yes, +1 point).
}
  \item{juxta_articular_bone_formation}{
Numeric (0 or 1). Ill-defined ossification near joint margins (excluding osteophyte formation) on plain radiographs of hand or foot. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{Total_Score}{The calculated CASPAR score (Range 0-6).}
\item{Classification}{"Classified as Psoriatic Arthritis" if Score >= 3, otherwise "Not Classified".}
}
\references{
Taylor W, Gladman D, Helliwell P, et al. Classification criteria for psoriatic arthritis: development of new criteria from a large international study. Arthritis Rheum. 2006;54(8):2665-2673. doi:10.1002/art.21972
}
\examples{

# Example 1: Classified as PsA
# Inflammatory disease present, Current Psoriasis (+2), Nail Dystrophy (+1)
# Score = 3
caspar_psoriatic_arthritis(1, 1, 0, 0, 1, 0, 0, 0)

# Example 2: Not Classified
# Inflammatory disease present, Family Hx (+1), Negative RF (+1)
# Score = 2
caspar_psoriatic_arthritis(1, 0, 0, 1, 0, 1, 0, 0)
}
