\name{centor_score_modified}
\alias{centor_score_modified}
\title{
Centor Score (Modified/McIsaac) for Strep Pharyngitis
}
\description{
Calculates the Modified Centor (McIsaac) Score to estimate the probability that pharyngitis is caused by Group A Beta-hemolytic Streptococcus (GAS) and to guide testing and antibiotic therapy. This modification adjusts the original Centor criteria for patient age.
}
\usage{
centor_score_modified(age, tonsillar_exudate, tender_anterior_cervical_adenopathy,
                      fever_history, absence_of_cough)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
3-14 years: +1 point.
15-44 years: 0 points.
>= 45 years: -1 point.
}
  \item{tonsillar_exudate}{
Numeric (0 or 1). Presence of tonsillar swelling or exudate. (1 = Yes, +1 point).
}
  \item{tender_anterior_cervical_adenopathy}{
Numeric (0 or 1). Presence of tender anterior cervical lymphadenopathy. (1 = Yes, +1 point).
}
  \item{fever_history}{
Numeric (0 or 1). History of fever (> 38 C / 100.4 F). (1 = Yes, +1 point).
}
  \item{absence_of_cough}{
Numeric (0 or 1). Absence of cough. (1 = Yes/Absent, +1 point).
}
}
\value{
A list containing:
\item{Centor_Score}{The calculated score (Range -1 to 5).}
\item{Strep_Probability}{Estimated risk of streptococcal infection.}
\item{Management_Guideline}{Recommendations regarding Rapid Antigen Detection Testing (RADT), culture, and antibiotics.}
}
\references{
McIsaac WJ, Kellner JD,ont P, Esmail A, et al. Empirical validation of guidelines for the management of pharyngitis in children and adults. JAMA. 2004;291(13):1587-1595. doi:10.1001/jama.291.13.1587

Centor RM, Witherspoon JM, Dalton HP, Brody CE, Link K. The diagnosis of strep throat in adults in the emergency room. Med Decis Making. 1981;1(3):239-246. doi:10.1177/0272989x8100100304
}
\examples{

# Example 1: High Risk Child
# 10yo (+1), Exudate (+1), Nodes (+1), No Fever (0), No Cough (+1)
# Score = 4
centor_score_modified(10, 1, 1, 0, 1)

# Example 2: Low Risk Adult
# 50yo (-1), No Exudate, No Nodes, Fever (+1), Cough present (0)
# Score = 0
centor_score_modified(50, 0, 0, 1, 0)
}
