\name{chads2_score}
\alias{chads2_score}
\title{
CHADS2 Score for Atrial Fibrillation Stroke Risk
}
\description{
Calculates the CHADS2 score to estimate the risk of stroke in patients with non-rheumatic atrial fibrillation. The score is used to determine whether anticoagulation therapy (e.g., warfarin, aspirin) is indicated.
}
\usage{
chads2_score(chf, hypertension, age, diabetes, stroke_tia)
}
\arguments{
  \item{chf}{
Numeric (0 or 1). History of Congestive Heart Failure. (1 = Yes, +1 point).
}
  \item{hypertension}{
Numeric (0 or 1). History of Hypertension. (1 = Yes, +1 point).
}
  \item{age}{
Numeric. Patient age in years. (>= 75 years adds +1 point).
}
  \item{diabetes}{
Numeric (0 or 1). History of Diabetes Mellitus. (1 = Yes, +1 point).
}
  \item{stroke_tia}{
Numeric (0 or 1). History of prior Stroke or TIA. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{CHADS2_Score}{The calculated score (Range 0-6).}
\item{Risk_Category}{Classification (Low, Moderate, High).}
\item{Annual_Stroke_Risk}{Estimated annual stroke risk percentage without anticoagulation.}
}
\references{
Gage BF, Waterman AD, Shannon W, et al. Validation of clinical classification schemes for predicting stroke: results from the National Registry of Atrial Fibrillation. JAMA. 2001;285(22):2864-2870. doi:10.1001/jama.285.22.2864
}
\examples{

# Example 1: High Risk
# 76yo (+1), History of Stroke (+2)
# Score = 3
chads2_score(0, 0, 76, 0, 1)

# Example 2: Moderate Risk
# 60yo (0), Hypertension (+1)
# Score = 1
chads2_score(0, 1, 60, 0, 0)
}
