\name{covid_risk_score}
\alias{covid_risk_score}
\title{
COVID-19 Vulnerability Index (CVI)
}
\description{
Calculates a risk score for severe COVID-19 outcomes (hospitalization, ICU admission, or death) based on demographic factors and comorbidities. This tool helps identify individuals at elevated risk to prioritize precautions or vaccination.
}
\usage{
covid_risk_score(age_years, sex, chronic_lung_disease, kidney_disease, chf, cad,
                 hypertension, diabetes, cancer, stroke, nursing_home_resident)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years.
<50: 0 pts.
50-64: 2 pts.
65-79: 3 pts.
>=80: 5 pts.
}
  \item{sex}{
String. "male" (+2 pts) or "female" (0 pts).
}
  \item{chronic_lung_disease}{
Numeric (0 or 1). History of chronic lung disease (COPD, asthma, etc.). (1 = Yes, +1 pt).
}
  \item{kidney_disease}{
Numeric (0 or 1). History of chronic kidney disease. (1 = Yes, +1 pt).
}
  \item{chf}{
Numeric (0 or 1). History of congestive heart failure. (1 = Yes, +1 pt).
}
  \item{cad}{
Numeric (0 or 1). History of coronary artery disease. (1 = Yes, +1 pt).
}
  \item{hypertension}{
Numeric (0 or 1). History of hypertension. (1 = Yes, +1 pt).
}
  \item{diabetes}{
Numeric (0 or 1). History of diabetes mellitus. (1 = Yes, +1 pt).
}
  \item{cancer}{
Numeric (0 or 1). History of cancer (excluding non-melanoma skin cancer). (1 = Yes, +1 pt).
}
  \item{stroke}{
Numeric (0 or 1). History of stroke/TIA. (1 = Yes, +1 pt).
}
  \item{nursing_home_resident}{
Numeric (0 or 1). Resident of a nursing home or long-term care facility. (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{COVID_Risk_Score}{The calculated total score.}
\item{Risk_Category}{Classification (Low <= 5, Intermediate 6-9, High >= 10).}
}
\references{
Specific reference for "COVID Risk Score" varies by institution/implementation (e.g., Cleveland Clinic, various vulnerability indices). This logic follows the general additive model used in many public health tools during the pandemic.
}
\examples{

# Example 1: High Risk
# 70yo (+3), Male (+2), Diabetes (+1), HTN (+1), Nursing Home (+2)
# Score = 9
covid_risk_score(70, "male", 0, 0, 0, 0, 1, 1, 0, 0, 1)

# Example 2: Low Risk
# 30yo (0), Female (0), Asthma (+1)
# Score = 1
covid_risk_score(30, "female", 1, 0, 0, 0, 0, 0, 0, 0, 0)
}
