\name{danger_assessment_tool}
\alias{danger_assessment_tool}
\title{
Danger Assessment Tool
}
\description{
Calculates the Danger Assessment score to determine the level of danger and risk of homicide in abusive relationships. The score is a weighted sum of 20 risk factors (though standardized simplified versions may use 19 weighted inputs).
}
\usage{
danger_assessment_tool(increase_severity, gun_in_house, partner_unemployed,
                       weapon_used, threat_to_kill, spy_on_partner,
                       forced_sex, choking, alcohol_abuse, drug_use,
                       violent_jealousy, controlling_behavior,
                       beaten_while_pregnant, stepchild_in_home,
                       threaten_children, partner_suicide_threat,
                       arrest_record, left_or_separated, capable_of_killing)
}
\arguments{
  \item{increase_severity}{
Numeric (0 or 1). Has the physical violence increased in severity or frequency over the past year? (1 = Yes, +3).
}
  \item{gun_in_house}{
Numeric (0 or 1). Does he own a gun? (1 = Yes, +3).
}
  \item{partner_unemployed}{
Numeric (0 or 1). Is he unemployed? (1 = Yes, +4).
}
  \item{weapon_used}{
Numeric (0 or 1). Has he ever used a weapon against you or threatened you with a lethal weapon? (1 = Yes, +3).
}
  \item{threat_to_kill}{
Numeric (0 or 1). Does he threaten to kill you? (1 = Yes, +3).
}
  \item{spy_on_partner}{
Numeric (0 or 1). Does he follow or spy on you, leave threatening notes/messages, destroy property, or call when you don't want him to? (1 = Yes, +2).
}
  \item{forced_sex}{
Numeric (0 or 1). Have you ever been forced to have sex when you didn't want to? (1 = Yes, +3).
}
  \item{choking}{
Numeric (0 or 1). Has he ever tried to choke you? (1 = Yes, +3).
}
  \item{alcohol_abuse}{
Numeric (0 or 1). Is he an alcoholic or problem drinker? (1 = Yes, +1).
}
  \item{drug_use}{
Numeric (0 or 1). Does he use illegal drugs? (1 = Yes, +1).
}
  \item{violent_jealousy}{
Numeric (0 or 1). Is he violently or constantly jealous? (1 = Yes, +1).
}
  \item{controlling_behavior}{
Numeric (0 or 1). Does he try to control most of your daily activities? (1 = Yes, +1).
}
  \item{beaten_while_pregnant}{
Numeric (0 or 1). Have you ever been beaten while you were pregnant? (1 = Yes, +1).
}
  \item{stepchild_in_home}{
Numeric (0 or 1). Is there a stepchild in the home? (1 = Yes, +2).
}
  \item{threaten_children}{
Numeric (0 or 1). Does he threaten to harm your children? (1 = Yes, +1).
}
  \item{partner_suicide_threat}{
Numeric (0 or 1). Has he ever threatened or tried to commit suicide? (1 = Yes, +1).
}
  \item{arrest_record}{
Numeric (0 or 1). Has he ever been arrested for domestic violence? (1 = Yes, +1).
}
  \item{left_or_separated}{
Numeric (0 or 1). Did you leave him after living together during the past year? (1 = Yes, +4).
}
  \item{capable_of_killing}{
Numeric (0 or 1). Do you believe he is capable of killing you? (1 = Yes, +3).
}
}
\value{
A list containing:
\item{DA_Score}{The total weighted risk score.}
\item{Risk_Level}{Classification (Variable, Increased, Severe, Extreme Danger).}
}
\references{
Campbell JC, Webster DW, Koziol-McLain J, et al. Risk factors for femicide in abusive relationships: results from a multisite case control study. Am J Public Health. 2003;93(7):1089-1097. doi:10.2105/ajph.93.7.1089
}
\examples{

# Example 1: Extreme Danger
# Unemployed, Gun, Left him, Choked, Forced Sex
# Score = 4 + 3 + 4 + 3 + 3 = 17 (Severe/Extreme border)
danger_assessment_tool(0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0)

# Example 2: Variable Danger
# Jealousy, Control, Alcohol
# Score = 1 + 1 + 1 = 3
danger_assessment_tool(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0)
}
