\name{disease_steps_ms}
\alias{disease_steps_ms}
\title{
Disease Steps for Multiple Sclerosis
}
\description{
Retrieves the clinical description for a given Disease Steps (DS) score. The Disease Steps scale is a simple, ordinal rating system (0-6) used to classify functional disability in Multiple Sclerosis patients, primarily based on ambulation and gait. It serves as a complementary tool to the more complex Expanded Disability Status Scale (EDSS).
}
\usage{
disease_steps_ms(classification)
}
\arguments{
  \item{classification}{
Numeric (0-6). The patient's Disease Step score.
0: Normal.
1: Mild Disability (No visible gait abnormality).
2: Moderate Disability (Visible gait abnormality, walks 25ft <= 20s).
3: Early Cane (Intermittent support, walks 25ft <= 20s).
4: Late Cane (Dependent on unilateral support).
5: Bilateral Support (Dependent on bilateral support).
6: Confined to Wheelchair.
}
}
\value{
A list containing:
\item{Disease_Step}{The input score.}
\item{Clinical_Description}{The official definition of the functional status associated with the score.}
}
\references{
Hohol MJ, Orav EJ, Weiner HL. Disease steps in multiple sclerosis: a simple approach to evaluate disease progression. Neurology. 1995;45(2):251-255. doi:10.1212/wnl.45.2.251
}
\examples{

# Example 1: Moderate Disability
# Patient has a visible limp but walks 25 feet quickly
disease_steps_ms(2)

# Example 2: Late Cane
# Patient requires a cane at all times to walk 25 feet
disease_steps_ms(4)
}
