\name{dragon_score_stroke}
\alias{dragon_score_stroke}
\title{
DRAGON Score for Post-tPA Stroke Outcome
}
\description{
Calculates the DRAGON score to predict the 3-month functional outcome (modified Rankin Scale) in acute ischemic stroke patients treated with intravenous tissue plasminogen activator (tPA). The score ranges from 0 to 10, with higher scores indicating a worse prognosis.
}
\usage{
dragon_score_stroke(hyperdense_cerebral_artery, early_infarct_signs,
                    mrs_prestroke_gt_1, age, glucose, onset_to_treatment_gt_90,
                    baseline_nihss, glucose_units = "mg/dL")
}
\arguments{
  \item{hyperdense_cerebral_artery}{
Numeric (0 or 1). Presence of hyperdense cerebral artery sign on admission CT.
}
  \item{early_infarct_signs}{
Numeric (0 or 1). Presence of early infarct signs on admission CT.
}
  \item{mrs_prestroke_gt_1}{
Numeric (0 or 1). Pre-stroke modified Rankin Scale score > 1. (1 = Yes).
}
  \item{age}{
Numeric. Patient age in years.
<65: 0 pts.
65-79: 1 pt.
>=80: 2 pts.
}
  \item{glucose}{
Numeric. Baseline blood glucose level. (> 144 mg/dL or > 8 mmol/L adds 1 point).
}
  \item{onset_to_treatment_gt_90}{
Numeric (0 or 1). Onset to treatment time > 90 minutes. (1 = Yes).
}
  \item{baseline_nihss}{
Numeric. Baseline NIH Stroke Scale score.
0-4: 0 pts.
5-9: 1 pt.
10-15: 2 pts.
>15: 3 pts.
}
  \item{glucose_units}{
String. Units for glucose input. Options: "mg/dL" (default) or "mmol/L".
}
}
\details{
CT Findings Scoring:
- Neither hyperdense artery nor early infarct signs: 0 points.
- Either one present: 1 point.
- Both present: 2 points.
}
\value{
A list containing:
\item{DRAGON_Score}{The calculated total score (Range 0-10).}
\item{Risk_Category}{Prognostic grouping (Good, Intermediate, Poor).}
\item{Outcome_Probability_3_Months}{Estimated likelihood of good/poor outcome based on validation studies.}
}
\references{
Strbian D, Meretoja A, Ahlhelm FJ, et al. Predicting outcome of IV thrombolysis-treated ischemic stroke patients: the DRAGON score. Neurology. 2012;78(6):427-432. doi:10.1212/WNL.0b013e318245d2a9
}
\examples{

# Example 1: Poor Prognosis
# Both CT signs (2), mRS>1 (1), Age 85 (2), Gluc 150 (1), Time >90 (1), NIHSS 20 (3)
# Score = 10
dragon_score_stroke(1, 1, 1, 85, 150, 1, 20)

# Example 2: Good Prognosis
# No CT signs, mRS 0, Age 60, Gluc 100, Time <90, NIHSS 4
# Score = 0
dragon_score_stroke(0, 0, 0, 60, 100, 0, 4)
}
