\name{easi_score}
\alias{easi_score}
\title{
Eczema Area and Severity Index (EASI)
}
\description{
Calculates the EASI score, a tool used to measure the extent (area) and severity of atopic dermatitis (eczema). The body is divided into four regions (Head/Neck, Upper Limbs, Trunk, Lower Limbs), and weighted based on age (<8 years vs >=8 years).
}
\usage{
easi_score(age_years, area_scores, erythema_scores, induration_scores,
           excoriation_scores, lichenification_scores)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years. Determines the body region weighting multipliers.
}
  \item{area_scores}{
Numeric Vector (length 4). Area involvement score for [Head, Upper, Trunk, Lower].
0: 0\%
1: 1-9\%
2: 10-29\%
3: 30-49\%
4: 50-69\%
5: 70-89\%
6: 90-100\%
}
  \item{erythema_scores}{
Numeric Vector (length 4). Redness severity (0-3) for each region.
}
  \item{induration_scores}{
Numeric Vector (length 4). Thickness/Papulation severity (0-3) for each region.
}
  \item{excoriation_scores}{
Numeric Vector (length 4). Scratching severity (0-3) for each region.
}
  \item{lichenification_scores}{
Numeric Vector (length 4). Lined skin severity (0-3) for each region.
}
}
\value{
A list containing:
\item{EASI_Score}{The calculated total score (Range 0-72).}
\item{Severity_Category}{Classification (Clear, Almost Clear, Mild, Moderate, Severe, Very Severe).}
}
\references{
Hanifin JM, Thurston M, Omoto M, et al. The eczema area and severity index (EASI): assessment of reliability in atopic dermatitis. EASI Evaluator Group. Exp Dermatol. 2001;10(1):11-18. doi:10.1034/j.1600-0625.2001.100102.x
Leshem YA, Hajar T, Hanifin JM, Simpson EL. What the Eczema Area and Severity Index score tells us about the severity of atopic dermatitis: an interpretability study. Br J Dermatol. 2015;172(5):1353-1357.
}
\examples{

# Example 1: Adult with Moderate Eczema
# Age 30
# Area scores: Head(1), Upper(2), Trunk(2), Lower(3)
# Erythema:    1, 2, 2, 2
# Induration:  1, 1, 2, 2
# Excoriation: 1, 2, 1, 2
# Lichenif:    0, 1, 1, 2
easi_score(30, c(1, 2, 2, 3), c(1, 2, 2, 2), c(1, 1, 2, 2), c(1, 2, 1, 2), c(0, 1, 1, 2))

# Example 2: Child (<8) with Severe Eczema
# Age 5 (Different multipliers)
# High scores across all regions
easi_score(5, c(4, 4, 5, 5), c(3, 3, 3, 3), c(2, 2, 3, 3), c(2, 3, 3, 3), c(1, 2, 2, 2))
}
