\name{eat_sleep_console_score}
\alias{eat_sleep_console_score}
\title{
Eat, Sleep, Console (ESC) Assessment for NAS
}
\description{
Calculates the Eat, Sleep, Console (ESC) score to assist in the management of infants with Neonatal Abstinence Syndrome (NAS) or Neonatal Opioid Withdrawal Syndrome (NOWS). This functional assessment prioritizes non-pharmacologic care and family involvement over traditional scoring systems like Finnegan.
}
\usage{
eat_sleep_console_score(eating_well, sleeping_well, easy_to_console)
}
\arguments{
  \item{eating_well}{
Numeric (0 or 1). Can the infant eat >= 1 ounce per feed or breastfeed well? (1 = Yes).
}
  \item{sleeping_well}{
Numeric (0 or 1). Can the infant sleep >= 1 hour continuously? (1 = Yes).
}
  \item{easy_to_console}{
Numeric (0 or 1). Can the infant be consoled within 10 minutes? (1 = Yes).
}
}
\value{
A list containing:
\item{ESC_Total_Score}{The sum of positive criteria met (Range 0-3).}
\item{Recommendation}{Clinical guidance based on whether all functional criteria are met.}
}
\references{
Grossman MR, Berkwitt AK, Osborn RR, et al. An Initiative to Improve the Quality of Care of Infants With Neonatal Abstinence Syndrome. Pediatrics. 2017;139(6):e20163360. doi:10.1542/peds.2016-3360
}
\examples{

# Example 1: Well Managed
# Eating well, sleeping well, easy to console
eat_sleep_console_score(1, 1, 1)

# Example 2: Intervention Needed
# Poor feeding, poor sleep, hard to console
eat_sleep_console_score(0, 0, 0)

# Example 3: Intervention Needed
# Eating well, sleeping well, but hard to console
eat_sleep_console_score(1, 1, 0)
}
