\name{esas_r_assessment}
\alias{esas_r_assessment}
\title{
Edmonton Symptom Assessment System (Revised) (ESAS-r)
}
\description{
Calculates the total distress score and categorizes symptom severity for the ESAS-r. This tool is designed to assist in the assessment of nine common symptoms in palliative care patients: Pain, Tiredness, Drowsiness, Nausea, Lack of Appetite, Shortness of Breath, Depression, Anxiety, and Wellbeing.
}
\usage{
esas_r_assessment(pain, tiredness, drowsiness, nausea, lack_of_appetite,
                  shortness_of_breath, depression, anxiety, wellbeing,
                  other_symptom_score = NULL)
}
\arguments{
  \item{pain}{
Numeric (0-10). 0 = No Pain, 10 = Worst Possible Pain.
}
  \item{tiredness}{
Numeric (0-10). 0 = Not Tired, 10 = Worst Possible Tiredness.
}
  \item{drowsiness}{
Numeric (0-10). 0 = Not Drowsy, 10 = Worst Possible Drowsiness.
}
  \item{nausea}{
Numeric (0-10). 0 = No Nausea, 10 = Worst Possible Nausea.
}
  \item{lack_of_appetite}{
Numeric (0-10). 0 = Good Appetite, 10 = Worst Possible Appetite.
}
  \item{shortness_of_breath}{
Numeric (0-10). 0 = No Shortness of Breath, 10 = Worst Possible Shortness of Breath.
}
  \item{depression}{
Numeric (0-10). 0 = No Depression, 10 = Worst Possible Depression.
}
  \item{anxiety}{
Numeric (0-10). 0 = No Anxiety, 10 = Worst Possible Anxiety.
}
  \item{wellbeing}{
Numeric (0-10). 0 = Best Wellbeing, 10 = Worst Possible Wellbeing.
}
  \item{other_symptom_score}{
Numeric (0-10) (Optional). Score for an additional patient-identified symptom (e.g., Constipation).
}
}
\value{
A list containing:
\item{Total_Symptom_Distress_Score}{Sum of all symptom scores (Range 0-90+).}
\item{Subscores}{Breakdown of Physical (6 items) and Emotional (2 items) distress.}
\item{Severity_Profile}{Categorization of each symptom as None (0), Mild (1-3), Moderate (4-6), or Severe (7-10).}
}
\references{
Bruera E, Kuehn N, Miller MJ, Selmser P, Macmillan K. The Edmonton Symptom Assessment System (ESAS): a simple method for the assessment of palliative care patients. J Palliat Care. 1991;7(2):6-9.
Watanabe SM, et al. Necrotizing fasciitis: The Edmonton Symptom Assessment System-revised (ESAS-r). Palliative Medicine. 2011.
}
\examples{

# Example 1: High Distress
# Severe Pain(8), Tiredness(7), Anxiety(6), others mild
esas_r_assessment(8, 7, 2, 1, 5, 2, 4, 6, 5)

# Example 2: Low Distress
# All items 0 or 1
esas_r_assessment(1, 0, 0, 0, 1, 0, 0, 0, 1)
}
