\name{fisher_sah_grade}
\alias{fisher_sah_grade}
\title{
Fisher Grading Scale for Subarachnoid Hemorrhage (SAH)
}
\description{
Calculates the Fisher Grade for patients with subarachnoid hemorrhage based on initial CT scan findings. The scale predicts the risk of cerebral vasospasm. Note that Grade 3 (Thick clot) carries the highest risk, higher than Grade 4 (ICH/IVH).
}
\usage{
fisher_sah_grade(sah_present, ich_ivh_present, clot_thickness_ge_1mm)
}
\arguments{
  \item{sah_present}{
Numeric (0 or 1). Is subarachnoid blood detected on CT? (1 = Yes).
}
  \item{ich_ivh_present}{
Numeric (0 or 1). Is there an intracerebral (ICH) or intraventricular (IVH) clot? (1 = Yes). Note: In the original Fisher scale, this finding (Grade 4) defines the category regardless of SAH thickness, though clinically Grade 3 implies higher vasospasm risk.
}
  \item{clot_thickness_ge_1mm}{
Numeric (0 or 1). Are localized clots or vertical layers >= 1mm thick present? (1 = Yes).
}
}
\value{
A list containing:
\item{Fisher_Grade}{The calculated grade (1-4).}
\item{CT_Findings}{The description of the grade.}
\item{Vasospasm_Risk}{Estimated percentage risk of developing vasospasm.}
}
\references{
Fisher CM, Kistler JP, Davis JM. Relation of cerebral vasospasm to subarachnoid hemorrhage visualized by computerized tomographic scanning. Neurosurgery. 1980;6(1):1-9. doi:10.1227/00006123-198001000-00001
}
\examples{

# Example 1: Highest Risk (Grade 3)
# SAH present, No ICH/IVH, Thick clot
fisher_sah_grade(1, 0, 1)

# Example 2: Grade 4
# SAH present, ICH present (overrides thickness in classification logic)
fisher_sah_grade(1, 1, 0)
}
