\name{fracture_index_score}
\alias{fracture_index_score}
\title{
Fracture Index (SOF) for Postmenopausal Women
}
\description{
Calculates the Fracture Index (based on the Study of Osteoporotic Fractures) to predict the 5-year risk of hip, vertebral, or any non-vertebral fracture in postmenopausal women without using Bone Mineral Density (BMD). The score aggregates simple clinical risk factors including age, fracture history, maternal history, weight, smoking status, and functional mobility (chair rise).
}
\usage{
fracture_index_score(age, history_fracture_after_50, maternal_hip_fracture,
                     weight_lt_57kg, smoker, uses_arms_to_stand)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<65: 0 pts.
65-69: 1 pt.
70-74: 2 pts.
75-79: 3 pts.
>=80: 4 pts.
}
  \item{history_fracture_after_50}{
Numeric (0 or 1). History of any fracture after age 50. (1 = Yes, +1 pt).
}
  \item{maternal_hip_fracture}{
Numeric (0 or 1). History of hip fracture in the patient's mother after age 50. (1 = Yes, +1 pt).
}
  \item{weight_lt_57kg}{
Numeric (0 or 1). Does the patient weigh less than 57 kg (125 lbs)? (1 = Yes, +1 pt).
}
  \item{smoker}{
Numeric (0 or 1). Is the patient a current smoker? (1 = Yes, +1 pt).
}
  \item{uses_arms_to_stand}{
Numeric (0 or 1). Does the patient need to use their arms to stand up from a chair? (1 = Yes, +1 pt).
}
}
\value{
A list containing:
\item{Fracture_Index_Score}{The calculated score (Range 0-9+).}
\item{Est_5Yr_Hip_Fracture_Risk}{Estimated percentage risk of hip fracture over 5 years.}
\item{Est_5Yr_Any_Fracture_Risk}{Estimated percentage risk of any non-vertebral fracture over 5 years.}
\item{Bone_Density_Correlation}{General correlation with BMD status (e.g., Osteoporosis likelihood).}
}
\references{
Black DM, Steinbuch M, Palermo L, et al. An assessment tool for predicting fracture risk in postmenopausal women. Osteoporos Int. 2001;12(7):519-528. doi:10.1007/s001980170072
}
\examples{

# Example 1: High Risk
# 82yo (+4), Prior Fx (+1), Uses arms (+1)
# Score = 6
fracture_index_score(82, 1, 0, 0, 0, 1)

# Example 2: Low Risk
# 60yo (0), No risk factors
# Score = 0
fracture_index_score(60, 0, 0, 0, 0, 0)
}
