\name{gap_index_ipf}
\alias{gap_index_ipf}
\title{
GAP Index for Idiopathic Pulmonary Fibrosis (IPF) Mortality
}
\description{
Calculates the GAP (Gender, Age, Physiology) Index to predict 1-, 2-, and 3-year mortality in patients with Idiopathic Pulmonary Fibrosis. The score stratifies patients into three stages based on four predictors: sex, age, forced vital capacity (FVC), and diffusing capacity of the lung for carbon monoxide (DLCO).
}
\usage{
gap_index_ipf(sex, age, fvc_percent, dlco_percent, dlco_unable_to_perform = 0)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds 1 point).
}
  \item{age}{
Numeric. Patient age in years.
<= 60: 0 pts.
61-65: 1 pt.
> 65: 2 pts.
}
  \item{fvc_percent}{
Numeric. Predicted Forced Vital Capacity (FVC) percentage.
> 75\%: 0 pts.
50-75\%: 1 pt.
< 50\%: 2 pts.
}
  \item{dlco_percent}{
Numeric. Predicted Diffusing Capacity of the Lung for Carbon Monoxide (DLCO) percentage. Required if 'dlco_unable_to_perform' is 0.
> 55\%: 0 pts.
36-55\%: 1 pt.
<= 35\%: 2 pts.
}
  \item{dlco_unable_to_perform}{
Numeric (0 or 1). Is the patient unable to perform the DLCO maneuver? (1 = Yes).
If Yes, score is 3 points for this category.
}
}
\value{
A list containing:
\item{GAP_Score}{The calculated total score (Range 0-8).}
\item{GAP_Stage}{The disease stage (I, II, or III).}
\item{Mortality_Risk}{Estimated mortality rates at 1, 2, and 3 years.}
}
\references{
Ley B, Ryerson CJ, Vittinghoff E, et al. A multidimensional index and staging system for idiopathic pulmonary fibrosis. Ann Intern Med. 2012;156(10):684-691. doi:10.7326/0003-4819-156-10-201205150-00004
}
\examples{

# Example 1: Stage I (Low Risk)
# Female (0), 55yo (0), FVC 80% (0), DLCO 60% (0)
# Score = 0
gap_index_ipf("female", 55, 80, 60)

# Example 2: Stage III (High Risk)
# Male (1), 70yo (2), FVC 45% (2), DLCO Unable (3)
# Score = 1 + 2 + 2 + 3 = 8
gap_index_ipf("male", 70, 45, 0, 1)
}
