\name{gds15_depression_screen}
\alias{gds15_depression_screen}
\title{
Geriatric Depression Scale (GDS-15)
}
\description{
Calculates the score for the Geriatric Depression Scale (Short Form). This 15-item screening tool is designed specifically for older adults. Responses are binary (Yes/No), and the scoring algorithm accounts for reverse-coded items where a negative answer indicates depression.
}
\usage{
gds15_depression_screen(satisfied_with_life, dropped_activities, life_empty,
                        often_bored, good_spirits, afraid_something_bad,
                        happy_most_time, often_helpless, prefer_stay_home,
                        memory_problems, wonderful_alive, worthless,
                        full_energy, hopeless, others_better_off)
}
\arguments{
  \item{satisfied_with_life}{
Numeric (0 or 1). Are you basically satisfied with your life? (1=Yes, 0=No). Note: 0 scores 1 point.
}
  \item{dropped_activities}{
Numeric (0 or 1). Have you dropped many of your activities and interests? (1=Yes, 0=No).
}
  \item{life_empty}{
Numeric (0 or 1). Do you feel that your life is empty? (1=Yes, 0=No).
}
  \item{often_bored}{
Numeric (0 or 1). Do you often get bored? (1=Yes, 0=No).
}
  \item{good_spirits}{
Numeric (0 or 1). Are you in good spirits most of the time? (1=Yes, 0=No). Note: 0 scores 1 point.
}
  \item{afraid_something_bad}{
Numeric (0 or 1). Are you afraid that something bad is going to happen to you? (1=Yes, 0=No).
}
  \item{happy_most_time}{
Numeric (0 or 1). Do you feel happy most of the time? (1=Yes, 0=No). Note: 0 scores 1 point.
}
  \item{often_helpless}{
Numeric (0 or 1). Do you often feel helpless? (1=Yes, 0=No).
}
  \item{prefer_stay_home}{
Numeric (0 or 1). Do you prefer to stay at home, rather than going out and doing new things? (1=Yes, 0=No).
}
  \item{memory_problems}{
Numeric (0 or 1). Do you feel you have more problems with memory than most? (1=Yes, 0=No).
}
  \item{wonderful_alive}{
Numeric (0 or 1). Do you think it is wonderful to be alive now? (1=Yes, 0=No). Note: 0 scores 1 point.
}
  \item{worthless}{
Numeric (0 or 1). Do you feel pretty worthless the way you are now? (1=Yes, 0=No).
}
  \item{full_energy}{
Numeric (0 or 1). Do you feel full of energy? (1=Yes, 0=No). Note: 0 scores 1 point.
}
  \item{hopeless}{
Numeric (0 or 1). Do you feel that your situation is hopeless? (1=Yes, 0=No).
}
  \item{others_better_off}{
Numeric (0 or 1). Do you think that most people are better off than you are? (1=Yes, 0=No).
}
}
\value{
A list containing:
\item{GDS15_Score}{The calculated total score (Range 0-15).}
\item{Interpretation}{Clinical severity (Normal <=4, Mild 5-8, Moderate 9-11, Severe 12-15).}
}
\references{
Sheikh JI, Yesavage JA. Geriatric Depression Scale (GDS): recent evidence and development of a shorter version. Clin Gerontol. 1986;5(1/2):165-173.
}
\examples{

# Example 1: Severe Depression
# Answered in the depressive direction for all questions
gds15_depression_screen(0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1)

# Example 2: Normal
# Answered in the positive/healthy direction for all questions
gds15_depression_screen(1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0)
}
