\name{gupta_mica_risk}
\alias{gupta_mica_risk}
\title{
Gupta Perioperative Risk for Myocardial Infarction or Cardiac Arrest (MICA)
}
\description{
Calculates the percentage risk of perioperative Myocardial Infarction (MI) or Cardiac Arrest (MICA) within 30 days of surgery. This model was derived from the NSQIP database and provides a site-specific risk assessment based on five preoperative predictors.
}
\usage{
gupta_mica_risk(age, creatinine_mg_dl, asa_class, functional_status,
                procedure_type)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{creatinine_mg_dl}{
Numeric. Preoperative serum creatinine in mg/dL.
}
  \item{asa_class}{
Numeric (1-5). American Society of Anesthesiologists Physical Status Classification.
1: Normal healthy patient.
2: Mild systemic disease.
3: Severe systemic disease.
4: Severe systemic disease that is a constant threat to life.
5: Moribund.
}
  \item{functional_status}{
String. Preoperative functional status. Options: "independent", "partially_dependent", "totally_dependent".
}
  \item{procedure_type}{
String. Surgical site/category. Valid options include:
"anorectal", "aortic", "bariatric", "brain", "breast", "cardiac", "ent", "foregut_hepatopancreatobiliary", "gallbladder_appendix_adrenal_spleen", "hernia_ventral_inguinal", "intestinal", "neck_thyroid_parathyroid", "obgyn", "ortho_non_spine", "spine", "thoracic_non_cardiac", "urology", "vascular_non_aortic", "vein".
}
}
\value{
A list containing:
\item{MICA_Risk_Percent}{The estimated percentage risk of perioperative MI or Cardiac Arrest.}
\item{Inputs}{A record of the parameters used for the calculation.}
}
\references{
Gupta PK, Gupta H, Sundaram A, et al. Development and validation of a risk calculator for prediction of cardiac risk after surgery. Circulation. 2011;124(4):381-387. doi:10.1161/CIRCULATIONAHA.110.015701
}
\examples{

# Example 1: High Risk (Aortic Surgery)
# 75yo, Cr 1.6, ASA 4, Partially Dependent
gupta_mica_risk(75, 1.6, 4, "partially_dependent", "aortic")

# Example 2: Low Risk (Breast Surgery)
# 45yo, Cr 0.8, ASA 1, Independent
gupta_mica_risk(45, 0.8, 1, "independent", "breast")
}
