\name{hit_4ts}
\alias{hit_4ts}
\title{
4Ts Score for Heparin-Induced Thrombocytopenia (HIT)
}
\description{
Calculates the 4Ts Score to estimate the pretest probability of Heparin-Induced Thrombocytopenia (HIT). The score ranges from 0 to 8 and categorizes patients into Low, Intermediate, or High probability groups.
}
\usage{
hit_4ts(thrombocytopenia_score, timing_score, thrombosis_score, other_causes_score)
}
\arguments{
  \item{thrombocytopenia_score}{
Numeric (0, 1, or 2). Points for magnitude of platelet fall.
2: Fall >50\% AND nadir >= 20.
1: Fall 30-50\% OR nadir 10-19.
0: Fall <30\% OR nadir < 10.
}
  \item{timing_score}{
Numeric (0, 1, or 2). Points for timing of platelet fall relative to heparin exposure.
2: Days 5-10 OR <=1 day (if prior exposure within 30 days).
1: >10 days OR unclear onset OR <=1 day (if prior exposure 30-100 days ago).
0: <4 days without recent exposure.
}
  \item{thrombosis_score}{
Numeric (0, 1, or 2). Points for thrombosis or other sequelae.
2: New confirmed thrombosis, skin necrosis, or acute systemic reaction.
1: Progressive/recurrent thrombosis, non-necrotizing skin lesions, or suspected thrombosis.
0: None.
}
  \item{other_causes_score}{
Numeric (0, 1, or 2). Points for likelihood of other causes for thrombocytopenia.
2: None apparent.
1: Possible.
0: Definite.
}
}
\value{
A list containing:
\item{Total_Score}{Sum of the 4 components (Range 0-8).}
\item{Pretest_Probability}{Risk category (Low, Intermediate, High) with estimated probability.}
\item{Interpretation}{Clinical likelihood of HIT.}
\item{Management_Guidance}{Suggested clinical actions based on risk.}
}
\references{
Lo GK, et al. Evaluation of pretest clinical score (4 T's) for the diagnosis of heparin-induced thrombocytopenia in two clinical settings. J Thromb Haemost. 2006;4(4):759-65. doi:10.1111/j.1538-7836.2006.01787.x
}
\examples{

# Example 1: High Probability
# >50\% drop (2), Days 5-10 (2), New Thrombosis (2), No other causes (2)
hit_4ts(2, 2, 2, 2)

# Example 2: Low Probability
# <30\% drop (0), Unclear timing (1), No thrombosis (0), Definite other cause (0)
hit_4ts(0, 1, 0, 0)
}
