\name{ho_trauma_index}
\alias{ho_trauma_index}
\title{
HO Index (Haemostasis and Oxygenation) for Trauma
}
\description{
Calculates the HO Index, a simple prognostic tool for predicting mortality in trauma patients with acute hemorrhage. It combines a marker of coagulopathy (INR) with a marker of shock/tissue hypoperfusion (Lactate).
}
\usage{
ho_trauma_index(inr, lactate_mmol_l)
}
\arguments{
  \item{inr}{
Numeric. International Normalized Ratio (Admission).
}
  \item{lactate_mmol_l}{
Numeric. Arterial or venous lactate in mmol/L (Admission).
}
}
\value{
A list containing:
\item{HO_Score}{The calculated index value (Formula: INR + Lactate/2).}
\item{Risk_Category}{Risk stratification for in-hospital mortality (Low < 1.5, Intermediate 1.5-3.0, High >= 3.0).}
}
\references{
Wafaisade A, Lefering R, Maegele M, et al. The HO-score: a simple tool to predict mortality in trauma patients with acute hemorrhage. Crit Care. 2016;20(1):193. doi:10.1186/s13054-016-1375-0
}
\examples{

# Example 1: High Risk
# INR 2.0, Lactate 6.0
# Score = 2.0 + (6.0 / 2) = 5.0
ho_trauma_index(2.0, 6.0)

# Example 2: Low Risk
# INR 1.0, Lactate 0.8
# Score = 1.0 + (0.8 / 2) = 1.4
ho_trauma_index(1.0, 0.8)
}
