\name{irae_endocrine_diabetes_grading}
\alias{irae_endocrine_diabetes_grading}
\title{
irAE Grading for Diabetes Mellitus (Endocrine Toxicities)
}
\description{
Calculates the CTCAE severity grade for hyperglycemia/diabetes mellitus associated with immune checkpoint inhibitor (ICPi) therapy. Grading is based on fasting glucose levels and the presence of life-threatening complications like ketoacidosis.
}
\usage{
irae_endocrine_diabetes_grading(fasting_glucose_mg_dl, metabolic_acidosis_present,
                                insulin_dependence)
}
\arguments{
  \item{fasting_glucose_mg_dl}{
Numeric. Fasting plasma glucose level in mg/dL.
}
  \item{metabolic_acidosis_present}{
Numeric (0 or 1). Presence of ketoacidosis or metabolic acidosis. (1 = Yes).
}
  \item{insulin_dependence}{
Numeric (0 or 1). Does the patient require insulin for control? (1 = Yes).
}
}
\value{
A list containing:
\item{CTCAE_Grade}{The calculated adverse event grade (1-4).}
\item{Definition}{Clinical description of the grade.}
\item{Management}{Recommended management strategy based on ASCO guidelines.}
}
\references{
Brahmer JR, Lacchetti C, Schneider BJ, et al. Management of Immune-Related Adverse Events in Patients Treated With Immune Checkpoint Inhibitor Therapy: American Society of Clinical Oncology Clinical Practice Guideline. J Clin Oncol. 2018;36(17):1714-1768. doi:10.1200/JCO.2017.77.6385
}
\examples{

# Example 1: Severe Hyperglycemia
# Glucose 400 mg/dL, No Acidosis, Needs Insulin
irae_endocrine_diabetes_grading(400, 0, 1)

# Example 2: DKA (Life-threatening)
# Glucose 600 mg/dL, Acidosis Present
irae_endocrine_diabetes_grading(600, 1, 1)
}
