\name{jones_criteria_diagnosis}
\alias{jones_criteria_diagnosis}
\title{
Revised Jones Criteria for Acute Rheumatic Fever (2015)
}
\description{
Evaluates the 2015 Revised Jones Criteria to diagnose Acute Rheumatic Fever (ARF). The criteria are stratified by population risk (Low vs. Moderate/High) and differ for initial versus recurrent attacks. Diagnosis generally requires evidence of preceding Group A Streptococcal infection plus either 2 Major criteria or 1 Major + 2 Minor criteria.
}
\usage{
jones_criteria_diagnosis(risk_population, carditis, chorea, erythema_marginatum,
                         subcutaneous_nodules, joint_manifestation, fever_c,
                         esr, crp, prolonged_pr, evidence_gas, history_recurrence)
}
\arguments{
  \item{risk_population}{
String. "low" (ARF incidence <2/100k or RHD prevalence <1/1000) or "moderate_high".
}
  \item{carditis}{
Numeric (0 or 1). Clinical or subclinical carditis. (Major).
}
  \item{chorea}{
Numeric (0 or 1). Sydenham chorea. (Major).
}
  \item{erythema_marginatum}{
Numeric (0 or 1). Erythema marginatum. (Major).
}
  \item{subcutaneous_nodules}{
Numeric (0 or 1). Subcutaneous nodules. (Major).
}
  \item{joint_manifestation}{
String. Joint symptoms. Options: "none", "monoarthralgia", "polyarthralgia", "monoarthritis", "polyarthritis".
Classification depends on risk:
Low Risk: Polyarthritis (Major), Polyarthralgia (Minor).
Mod/High Risk: Mono/Polyarthritis (Major), Mono/Polyarthralgia (Minor).
}
  \item{fever_c}{
Numeric. Temperature in Celsius. (Low Risk cutoff >= 38.5, Mod/High >= 38.0).
}
  \item{esr}{
Numeric. Erythrocyte Sedimentation Rate (mm/hr). (Low Risk cutoff >= 60, Mod/High >= 30).
}
  \item{crp}{
Numeric. C-Reactive Protein (mg/dL). (Cutoff >= 3.0).
}
  \item{prolonged_pr}{
Numeric (0 or 1). Prolonged PR interval for age. (Minor). *Note: Cannot be counted if Carditis is counted as Major.*
}
  \item{evidence_gas}{
Numeric (0 or 1). Evidence of preceding Group A Streptococcal infection (culture, rapid antigen, or elevated ASO/DNAse B). (Required unless Chorea/Carditis is the presenting sign).
}
  \item{history_recurrence}{
Numeric (0 or 1). Patient has a history of ARF or Rheumatic Heart Disease. (1 = Yes).
If Yes, diagnosis can be made with 3 Minor criteria.
}
}
\value{
A list containing:
\item{Diagnosis}{"Positive" or "Negative/Criteria Not Met".}
\item{Major_Criteria_Met}{Count of Major criteria satisfied.}
\item{Minor_Criteria_Met}{Count of Minor criteria satisfied.}
}
\references{
Gewitz MH, Baltimore RS, Tani LY, et al. Revision of the Jones Criteria for the diagnosis of acute rheumatic fever in the era of Doppler echocardiography: a scientific statement from the American Heart Association. Circulation. 2015;131(20):1806-1818. doi:10.1161/CIR.0000000000000205
}
\examples{

# Example 1: Positive (Low Risk)
# Polyarthritis (Major), Fever 39 (Minor), ESR 70 (Minor), GAS Positive
# Result: Positive (1 Major + 2 Minor)
jones_criteria_diagnosis("low", 0, 0, 0, 0, "polyarthritis", 39.0, 70, 1.0, 0, 1, 0)

# Example 2: Positive (High Risk)
# Monoarthritis (Major), Fever 38.2 (Minor), CRP 5.0 (Minor), GAS Positive
# Result: Positive (1 Major + 2 Minor)
jones_criteria_diagnosis("moderate_high", 0, 0, 0, 0, "monoarthritis", 38.2, 10, 5.0, 0, 1, 0)
}
