\name{kings_college_criteria_acetaminophen}
\alias{kings_college_criteria_acetaminophen}
\title{
King's College Criteria for Acetaminophen Toxicity
}
\description{
Calculates the King's College Criteria (KCC) for predicting poor prognosis in patients with Acetaminophen (Paracetamol) induced acute liver failure. Meeting the criteria indicates a high risk of mortality without liver transplantation.
}
\usage{
kings_college_criteria_acetaminophen(arterial_ph, inr, creatinine,
                                     encephalopathy_grade,
                                     creatinine_units = "mg/dL")
}
\arguments{
  \item{arterial_ph}{
Numeric. Arterial blood pH.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{encephalopathy_grade}{
Numeric (0-4). Grade of hepatic encephalopathy (West Haven Criteria).
0: None.
1: Mild confusion/agitation.
2: Lethargy, disorientation.
3: Somnolence to semi-stupor, responsive to stimuli.
4: Coma.
}
  \item{creatinine_units}{
String. Units for creatinine input. Options: "mg/dL" (default) or "micromol/L" (or "umol/L").
}
}
\details{
Criteria for Liver Transplantation are met if:
1. Arterial pH < 7.3 (irrespective of grade of encephalopathy).
OR
2. All three of the following occur within a 24-hour period:
   - INR > 6.5 (PT > 100 seconds)
   - Serum Creatinine > 3.4 mg/dL (300 µmol/L)
   - Grade III or IV Encephalopathy
}
\value{
A list containing:
\item{Result}{Indication of whether the criteria for poor prognosis are met.}
\item{Recommendation}{Clinical guidance regarding transplant referral.}
\item{Criteria_Fulfilled}{Specific conditions that triggered the positive result.}
}
\references{
O'Grady JG, Alexander GJ, Hayllar KM, Williams R. Early indicators of prognosis in fulminant hepatic failure. Gastroenterology. 1989;97(2):439-445. doi:10.1016/0016-5085(89)90081-4
}
\examples{

# Example 1: Criteria Met (Acidosis)
# pH 7.1, INR 2.0, Cr 1.0, Grade 1 Enceph
kings_college_criteria_acetaminophen(7.1, 2.0, 1.0, 1)

# Example 2: Criteria Met (Triad)
# pH 7.35, INR 7.0, Cr 4.0, Grade 3 Enceph
kings_college_criteria_acetaminophen(7.35, 7.0, 4.0, 3)

# Example 3: Criteria Not Met
# pH 7.35, INR 5.0, Cr 2.0, Grade 2 Enceph
kings_college_criteria_acetaminophen(7.35, 5.0, 2.0, 2)
}
