\name{lace_readmission_index}
\alias{lace_readmission_index}
\title{
LACE Index for Readmission
}
\description{
Calculates the LACE Index to predict the risk of unplanned readmission or death within 30 days after hospital discharge. The score is based on Length of stay, Acuity of admission, Comorbidities (Charlson Index), and Emergency department visits in the previous 6 months.
}
\usage{
lace_readmission_index(length_of_stay_days, acute_admission,
                       charlson_comorbidity_index, ed_visits_6months)
}
\arguments{
  \item{length_of_stay_days}{
Numeric. Length of stay in days.
<1: 0 pts.
1: 1 pt.
2: 2 pts.
3: 3 pts.
4-6: 4 pts.
7-13: 5 pts.
>=14: 7 pts.
}
  \item{acute_admission}{
Numeric (0 or 1). Was the admission acute/emergent? (1 = Yes, +3 pts).
}
  \item{charlson_comorbidity_index}{
Numeric. The patient's Charlson Comorbidity Index score.
0: 0 pts.
1: 1 pt.
2: 2 pts.
3: 3 pts.
>=4: 5 pts.
}
  \item{ed_visits_6months}{
Numeric. Number of ED visits in the 6 months prior to admission (excluding the index admission).
0: 0 pts.
1: 1 pt.
2: 2 pts.
3: 3 pts.
>=4: 4 pts.
}
}
\value{
A list containing:
\item{LACE_Score}{The calculated total score (Range 0-19).}
\item{Risk_Category}{Classification (Low 0-4, Moderate 5-9, High >=10).}
\item{Est_30_Day_Readmission_Risk}{Estimated probability of readmission/death.}
}
\references{
van Walraven C, Dhalla IA, Bell C, et al. Derivation and validation of an index to predict early death or unplanned readmission after discharge from hospital to the community. CMAJ. 2010;182(6):551-557. doi:10.1503/cmaj.091117
}
\examples{

# Example 1: High Risk
# 5 day stay (+4), Acute (+3), CCI 5 (+5), 2 ED visits (+2)
# Score = 14
lace_readmission_index(5, 1, 5, 2)

# Example 2: Low Risk
# 2 day stay (+2), Elective (0), CCI 0 (0), 0 ED visits (0)
# Score = 2
lace_readmission_index(2, 0, 0, 0)
}
