\name{leiden_arthritis_prediction}
\alias{leiden_arthritis_prediction}
\title{
Leiden Clinical Prediction Rule for Undifferentiated Arthritis
}
\description{
Calculates the Leiden Prediction Rule score to estimate the likelihood that a patient with recent-onset undifferentiated arthritis will progress to Rheumatoid Arthritis (RA) within one year. The score uses clinical, serological, and demographic factors to stratify risk.
}
\usage{
leiden_arthritis_prediction(age_years, sex, distribution_small_hands_feet,
                            distribution_symmetric, morning_stiffness_severity,
                            tender_joint_count, swollen_joint_count, crp_mg_dl,
                            rf_positive, acpa_positive)
}
\arguments{
  \item{age_years}{
Numeric. Patient age in years. (0.02 points per year).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Female adds 1 point).
}
  \item{distribution_small_hands_feet}{
Numeric (0 or 1). Involvement of small joints of hands or feet? (1 = Yes, +0.5 pts).
}
  \item{distribution_symmetric}{
Numeric (0 or 1). Symmetric distribution of arthritis? (1 = Yes, +0.5 pts).
}
  \item{morning_stiffness_severity}{
Numeric (0 or 1). Morning stiffness >= 1 hour? (or score on VAS >= 26mm). (1 = Yes, +1 pt).
}
  \item{tender_joint_count}{
Numeric. Number of tender joints (0-68).
1-3 joints: +0.5 pts.
4-10 joints: +1 pt.
>=11 joints: +1.5 pts.
Note: This logic is simplified in many calculators; original paper bins joint counts: 1-3 (+0.5), 4-10 (+1), >10 (+1.5).
}
  \item{swollen_joint_count}{
Numeric. Number of swollen joints (0-66).
1-3 joints: +0.5 pts.
4-10 joints: +1 pt.
>=11 joints: +1.5 pts.
}
  \item{crp_mg_dl}{
Numeric. C-Reactive Protein level. (>= 5 mg/L or 0.5 mg/dL adds 1.5 pts. Note input unit here is mg/dL?).
*Correction*: Standard input is typically mg/L or mg/dL. Common cutoff is CRP >= 5 mg/L (which is 0.5 mg/dL). Assuming standard "elevated" check.
}
  \item{rf_positive}{
Numeric (0 or 1). Rheumatoid Factor positive? (1 = Yes, +1 pt).
}
  \item{acpa_positive}{
Numeric (0 or 1). Anti-Citrullinated Protein Antibody (ACPA/Anti-CCP) positive? (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{Leiden_Score}{The calculated risk score (Range 0-14).}
\item{Risk_Category}{Classification (Low, Intermediate, High).}
\item{Progression_Probability_1yr}{Estimated probability of progression to RA.}
}
\references{
van der Helm-van Mil AH, le Cessie S, van Dongen H, et al. A prediction rule for disease outcome in patients with recent-onset undifferentiated arthritis: how to guide individual treatment decisions. Arthritis Rheum. 2007;56(2):433-440. doi:10.1002/art.22380
}
\examples{

# Example 1: High Risk
# 50yo Female (+1+1), Small joints (+0.5), Sym (+0.5), Stiffness (+1),
# 5 tender (+1), 5 swollen (+1), CRP high (+1.5), RF (+1), ACPA (+2)
# Score approx 10.5
leiden_arthritis_prediction(50, "female", 1, 1, 1, 5, 5, 10, 1, 1)

# Example 2: Low Risk
# 40yo Male, Large joint (0), Asym (0), No stiff (0), 1 tender (0.5), 1 swollen (0.5), Normal labs
# Score = 0.8 + 0 + 0 + 0 + 0 + 0.5 + 0.5 + 0 = 1.8
leiden_arthritis_prediction(40, "male", 0, 0, 0, 1, 1, 0, 0, 0)
}
