\name{maps_systemic_mastocytosis_score}
\alias{maps_systemic_mastocytosis_score}
\title{
Mayo Alliance Prognostic System (MAPS) for Systemic Mastocytosis
}
\description{
Calculates the MAPS Score (Hybrid Clinical-Molecular Model) to predict overall survival in patients with Systemic Mastocytosis (SM). The score integrates clinical subtypes, age, laboratory findings, and high-risk mutations.
}
\usage{
maps_systemic_mastocytosis_score(sm_category, age, platelet_count,
                                 alp_elevated, adverse_mutations)
}
\arguments{
  \item{sm_category}{
String. Systemic Mastocytosis subtype.
"indolent": Indolent SM or Smoldering SM (0 points).
"advanced": Aggressive SM, Mast Cell Leukemia, or SM with Associated Hematologic Neoplasm (+2 points).
}
  \item{age}{
Numeric. Patient age in years. (> 60 years adds +1 point).
}
  \item{platelet_count}{
Numeric. Platelet count in x10^9/L. (< 150 x 10^9/L adds +1 point).
}
  \item{alp_elevated}{
Numeric (0 or 1). Serum Alkaline Phosphatase (ALP) above the upper limit of normal. (1 = Yes, +1 point).
}
  \item{adverse_mutations}{
Numeric (0 or 1). Presence of adverse mutations (ASXL1, RUNX1, or NRAS). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{MAPS_Score}{The calculated prognostic score (Range 0-6).}
\item{Risk_Category}{Classification (Low: 0, Intermediate: 1-2, High: >=3).}
}
\references{
Pardanani A, Lasho T, Elala Y, et al. Mayo alliance prognostic system for mastocytosis: clinical and hybrid clinical-molecular models. Blood Adv. 2018;2(21):2964-2972. doi:10.1182/bloodadvances.2018026229
}
\examples{

# Example 1: High Risk
# Advanced SM (+2), Age 65 (+1), Plt 100 (+1), ALP High (+1), No Mutations
# Score = 5
maps_systemic_mastocytosis_score("advanced", 65, 100, 1, 0)

# Example 2: Low Risk
# Indolent SM (0), Age 40 (0), Plt 250 (0), ALP Normal (0), No Mutations
# Score = 0
maps_systemic_mastocytosis_score("indolent", 40, 250, 0, 0)
}
