\name{mehran_score_cin}
\alias{mehran_score_cin}
\title{
Mehran Score for Post-PCI Contrast-Induced Nephropathy (CIN)
}
\description{
Calculates the Mehran Risk Score to predict the risk of Contrast-Induced Nephropathy (CIN) and the need for dialysis following Percutaneous Coronary Intervention (PCI). The score uses clinical factors (hypotension, IABP, CHF, age, diabetes, anemia), contrast volume, and renal function (Serum Creatinine or eGFR).
}
\usage{
mehran_score_cin(hypotension, intraaortic_balloon_pump, congestive_heart_failure,
                 age_gt_75, diabetes, anemia, contrast_volume_cc,
                 serum_creatinine_mg_dl = NULL, egfr_ml_min = NULL)
}
\arguments{
  \item{hypotension}{
Numeric (0 or 1). SBP < 80 mmHg for > 1 hour requiring inotropes or IABP support. (1 = Yes, +5 pts).
}
  \item{intraaortic_balloon_pump}{
Numeric (0 or 1). Use of IABP. (1 = Yes, +5 pts).
}
  \item{congestive_heart_failure}{
Numeric (0 or 1). CHF Class III/IV or history of pulmonary edema. (1 = Yes, +5 pts).
}
  \item{age_gt_75}{
Numeric (0 or 1). Age > 75 years. (1 = Yes, +4 pts).
}
  \item{diabetes}{
Numeric (0 or 1). History of diabetes. (1 = Yes, +3 pts).
}
  \item{anemia}{
Numeric (0 or 1). Baseline hematocrit < 39\% for men or < 36\% for women. (1 = Yes, +3 pts).
}
  \item{contrast_volume_cc}{
Numeric. Total volume of contrast media used in cc (mL). (1 point per 100 cc).
}
  \item{serum_creatinine_mg_dl}{
Numeric (Optional). Baseline Serum Creatinine in mg/dL. (> 1.5 mg/dL adds 4 pts). Note: Original score used SCr; updated versions often incorporate eGFR.
}
  \item{egfr_ml_min}{
Numeric (Optional). Estimated GFR in mL/min/1.73m^2. Used if Serum Creatinine is not provided for more granular scoring (20-40: +4, 40-60: +2, <20: +6).
}
}
\value{
A list containing:
\item{Mehran_Score}{The calculated risk score (Range 0-~30+).}
\item{Risk_Class}{Classification (Low, Moderate, High, Very High).}
\item{Risk_CIN}{Estimated probability of developing CIN (>= 25\% rise or >= 0.5 mg/dL increase in SCr).}
\item{Risk_Dialysis}{Estimated probability of requiring dialysis.}
}
\references{
Mehran R, Aymong ED, Nikolsky E, et al. A simple risk score for prediction of contrast-induced nephropathy after percutaneous coronary intervention: development and initial validation. J Am Coll Cardiol. 2004;44(7):1393-1399. doi:10.1016/j.jacc.2004.06.068
}
\examples{

# Example 1: High Risk
# Hypotension (+5), Diabetes (+3), Contrast 250cc (+2), SCr 1.8 (+4)
# Score = 14
mehran_score_cin(1, 0, 0, 0, 1, 0, 250, serum_creatinine_mg_dl = 1.8)

# Example 2: Low Risk
# Age 50 (0), Contrast 100cc (+1), Normal SCr (0), No other factors
# Score = 1
mehran_score_cin(0, 0, 0, 0, 0, 0, 100, serum_creatinine_mg_dl = 0.9)
}
