\name{meld_score_pre_2016}
\alias{meld_score_pre_2016}
\title{
MELD Score (Original, Pre-2016)
}
\description{
Calculates the original Model for End-Stage Liver Disease (MELD) score. This version does not incorporate serum sodium (MELD-Na). It uses serum bilirubin, serum creatinine, and INR to predict 3-month mortality in patients with end-stage liver disease.
}
\usage{
meld_score_pre_2016(bilirubin, inr, creatinine, on_dialysis = 0,
                    bilirubin_units = "mg/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{bilirubin}{
Numeric. Total Bilirubin level.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{on_dialysis}{
Numeric (0 or 1). Has the patient had dialysis at least twice in the past week? (1 = Yes). If Yes, creatinine is automatically set to 4.0 mg/dL.
}
  \item{bilirubin_units}{
String. Units for bilirubin input. "mg/dL" (default) or "umol/L".
}
  \item{creatinine_units}{
String. Units for creatinine input. "mg/dL" (default) or "umol/L".
}
}
\details{
The formula is:
\deqn{MELD = 10 \times (0.957 \times \ln(Creatinine) + 0.378 \times \ln(Bilirubin) + 1.120 \times \ln(INR) + 0.643)}
Lower limits: Any laboratory value less than 1.0 is set to 1.0.
Upper limits: Creatinine is capped at 4.0 mg/dL.
The maximum MELD score is capped at 40.
}
\value{
A list containing:
\item{MELD_Score_Original}{The calculated score (Range 6-40).}
\item{Est_3_Month_Mortality}{Estimated 3-month mortality percentage.}
}
\references{
Kamath PS, Wiesner RH, Malinchoc M, et al. A model to predict survival in patients with end-stage liver disease. Hepatology. 2001;33(2):464-470. doi:10.1053/jhep.2001.22172
}
\examples{

# Example 1: Low Risk
# Bili 1.0, INR 1.0, Cr 1.0
# Score = 6
meld_score_pre_2016(1.0, 1.0, 1.0)

# Example 2: High Risk (Dialysis)
# Bili 5.0, INR 2.5, Cr 2.0 (on dialysis -> Cr set to 4.0)
# Score = 10 * (0.957*ln(4) + 0.378*ln(5) + 1.12*ln(2.5) + 0.643) = ~36
meld_score_pre_2016(5.0, 2.5, 2.0, 1)
}
