\name{multiple_myeloma_diagnosis}
\alias{multiple_myeloma_diagnosis}
\title{
IMWG Diagnostic Criteria for Multiple Myeloma
}
\description{
Evaluates patient data against the International Myeloma Working Group (IMWG) criteria to diagnose Active Multiple Myeloma, Smoldering Multiple Myeloma, or MGUS. Diagnosis of Active MM requires the presence of >=10\% clonal bone marrow plasma cells (or biopsy-proven plasmacytoma) plus at least one myeloma-defining event (CRAB feature or SLiM biomarker).
}
\usage{
multiple_myeloma_diagnosis(bmpc_percent, plasmacytoma, calcium_elevated,
                           renal_insufficiency, anemia, bone_lesions,
                           flc_ratio_gt_100, mri_focal_lesions_gt_1,
                           m_protein_g_dl = 0)
}
\arguments{
  \item{bmpc_percent}{
Numeric. Clonal bone marrow plasma cell percentage.
}
  \item{plasmacytoma}{
Numeric (0 or 1). Biopsy-proven bony or extramedullary plasmacytoma. (1 = Yes).
}
  \item{calcium_elevated}{
Numeric (0 or 1). Serum calcium > 1 mg/dL above upper limit of normal or > 11 mg/dL. (1 = Yes).
}
  \item{renal_insufficiency}{
Numeric (0 or 1). Renal insufficiency (Creatinine > 2 mg/dL or CrCl < 40 mL/min). (1 = Yes).
}
  \item{anemia}{
Numeric (0 or 1). Hemoglobin > 2 g/dL below lower limit of normal or < 10 g/dL. (1 = Yes).
}
  \item{bone_lesions}{
Numeric (0 or 1). One or more osteolytic bone lesions on skeletal radiography, CT, or PET-CT. (1 = Yes).
}
  \item{flc_ratio_gt_100}{
Numeric (0 or 1). Involved:Uninvolved serum free light chain ratio >= 100 (with involved FLC >= 100 mg/L). (1 = Yes).
}
  \item{mri_focal_lesions_gt_1}{
Numeric (0 or 1). >1 focal lesions on MRI (at least 5mm in size). (1 = Yes).
}
  \item{m_protein_g_dl}{
Numeric (Optional). Serum M-protein level in g/dL. Used to distinguish Smoldering MM from MGUS if BMPC is <10\%.
}
}
\value{
A list containing:
\item{Diagnosis}{The resulting diagnosis (Active MM, Smoldering MM, or MGUS).}
\item{Criteria_Met}{Summary of which major criteria categories (CRAB, SLiM) were satisfied.}
}
\references{
Rajkumar SV, Dimopoulos MA, Palumbo A, et al. International Myeloma Working Group updated criteria for the diagnosis of multiple myeloma. Lancet Oncol. 2014;15(12):e538-e548. doi:10.1016/S1470-2045(14)70442-5
}
\examples{

# Example 1: Active MM (CRAB feature)
# 15% BMPC, Anemia present
multiple_myeloma_diagnosis(15, 0, 0, 0, 1, 0, 0, 0)

# Example 2: Active MM (SLiM feature)
# 20% BMPC, No CRAB, but FLC Ratio > 100
multiple_myeloma_diagnosis(20, 0, 0, 0, 0, 0, 1, 0)

# Example 3: Smoldering MM
# 20% BMPC, No CRAB, No SLiM
multiple_myeloma_diagnosis(20, 0, 0, 0, 0, 0, 0, 0)
}
