\name{neonatal_eos_calculator}
\alias{neonatal_eos_calculator}
\title{
Neonatal Early-Onset Sepsis (EOS) Calculator
}
\description{
Calculates the probability of Early-Onset Sepsis (EOS) in newborns (>= 34 weeks gestation) based on maternal risk factors and the infant's clinical presentation. It uses a multivariate risk model (based on the Kaiser Permanente study) to adjust the prior probability derived from maternal factors by the likelihood ratio of the neonatal clinical status.
}
\usage{
neonatal_eos_calculator(gestational_age_weeks, highest_maternal_temp_c,
                        rom_hours, gbs_status, intrapartum_antibiotics,
                        neonatal_appearance, baseline_incidence_per_1000 = 0.5)
}
\arguments{
  \item{gestational_age_weeks}{
Numeric. Gestational age in weeks (must be >= 34).
}
  \item{highest_maternal_temp_c}{
Numeric. Highest maternal antepartum temperature in degrees Celsius.
}
  \item{rom_hours}{
Numeric. Duration of Rupture of Membranes in hours.
}
  \item{gbs_status}{
String. Maternal Group B Streptococcus status. Options: "positive", "negative", "unknown".
}
  \item{intrapartum_antibiotics}{
String. Type and duration of intrapartum antibiotics.
Options:
"none" (None or <2h before delivery),
"specific_lt_2" (GBS Specific < 2h),
"specific_2_to_3_9" (GBS Specific 2-3.9h),
"specific_ge_4" (GBS Specific >= 4h),
"broad_lt_2" (Broad Spectrum < 2h),
"broad_2_to_3_9" (Broad Spectrum 2-3.9h),
"broad_ge_4" (Broad Spectrum >= 4h).
}
  \item{neonatal_appearance}{
String. Clinical presentation of the neonate.
"well_appearing": Normal exam.
"equivocal": Abnormal vitals (e.g., tachycardia, tachypnea) but clinically stable.
"clinical_illness": Severe respiratory distress, shock, need for mechanical ventilation/pressors.
}
  \item{baseline_incidence_per_1000}{
Numeric. The local baseline incidence of EOS per 1000 live births (default 0.5).
}
}
\value{
A list containing:
\item{EOS_Risk_Per_1000}{The calculated posterior probability of sepsis per 1000 births.}
\item{Clinical_Presentation}{The input clinical status used for the likelihood ratio adjustment.}
\item{Recommendation}{Management guidance based on the calculated risk and clinical status (Routine care, Enhanced observation, or Antibiotics).}
}
\references{
Puopolo KM, Draper D, Wi S, et al. Estimating the probability of neonatal early-onset infection on the basis of maternal risk factors. Pediatrics. 2011;128(5):e1155-1163.
Puopolo KM, et al. Management of Neonates Born at >=34 6/7 Weeks' Gestation With Suspected or Proven Early-Onset Bacterial Sepsis. Pediatrics. 2018.
}
\examples{

# Example 1: Well appearing, 40 weeks, GBS neg, PROM 18h, Temp 38.5C
neonatal_eos_calculator(40, 38.5, 18, "negative", "none", "well_appearing")

# Example 2: Equivocal exam, 36 weeks, GBS pos, No Abx
neonatal_eos_calculator(36, 37.0, 12, "positive", "none", "equivocal")
}
