\name{nps_pain_scale}
\alias{nps_pain_scale}
\title{
Neuropathic Pain Scale (NPS)
}
\description{
Calculates the Neuropathic Pain Scale (NPS) score. Unlike diagnostic tools (e.g., DN4), the NPS is designed to assess the distinct qualities of neuropathic pain (e.g., sharp, hot, dull) and monitor changes in these specific symptoms over time or in response to treatment.
}
\usage{
nps_pain_scale(intensity, sharp, hot, dull, cold, sensitive, itchy,
               unpleasant, deep, surface)
}
\arguments{
  \item{intensity}{
Numeric (0-10). How intense is the pain? (0=No pain, 10=Most intense pain imaginable).
}
  \item{sharp}{
Numeric (0-10). How sharp is the pain? (0=Not sharp, 10=Most sharp sensation imaginable).
}
  \item{hot}{
Numeric (0-10). How hot is the pain? (0=Not hot, 10=Most hot sensation imaginable).
}
  \item{dull}{
Numeric (0-10). How dull is the pain? (0=Not dull, 10=Most dull sensation imaginable).
}
  \item{cold}{
Numeric (0-10). How cold is the pain? (0=Not cold, 10=Most cold sensation imaginable).
}
  \item{sensitive}{
Numeric (0-10). How sensitive is the skin to light touch/clothing? (0=Not sensitive, 10=Most sensitive sensation imaginable).
}
  \item{itchy}{
Numeric (0-10). How itchy is the pain? (0=Not itchy, 10=Most itchy sensation imaginable).
}
  \item{unpleasant}{
Numeric (0-10). How unpleasant is the pain? (0=Not unpleasant, 10=Most unpleasant sensation imaginable).
}
  \item{deep}{
Numeric (0-10). How intense is the deep pain? (0=No deep pain, 10=Most intense deep pain imaginable).
}
  \item{surface}{
Numeric (0-10). How intense is the surface pain? (0=No surface pain, 10=Most intense surface pain imaginable).
}
}
\value{
A list containing:
\item{NPS_Total_Score}{The sum of all 10 item scores (Range 0-100).}
\item{Interpretation}{Guidance on using the score for monitoring treatment response.}
\item{Domain_Scores}{A breakdown of the individual pain quality scores.}
}
\references{
Galer BS, Jensen MP. Development and preliminary validation of a pain measure specific to neuropathic pain: the Neuropathic Pain Scale. Neurology. 1997;48(2):332-338. doi:10.1212/wnl.48.2.332
}
\examples{

# Example 1: High Sharp/Sensitive Pain
# Intensity(8), Sharp(9), Hot(2), Dull(1), Cold(0), Sensitive(9),
# Itchy(0), Unpleasant(8), Deep(2), Surface(9)
# Total = 48
nps_pain_scale(8, 9, 2, 1, 0, 9, 0, 8, 2, 9)

# Example 2: Low Intensity
# All items scored 1
# Total = 10
nps_pain_scale(1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
}
