\name{oakland_score_lgib}
\alias{oakland_score_lgib}
\title{
Oakland Score for Safe Discharge in Lower GI Bleed
}
\description{
Calculates the Oakland Score to identify patients with lower gastrointestinal bleeding (LGIB) who are at low risk of adverse outcomes and can be safely discharged from the emergency department. A score of 8 or less indicates a 95\% probability of safe discharge (defined as absence of rebleeding, transfusion, therapeutic intervention, in-hospital death, or readmission).
}
\usage{
oakland_score_lgib(age, sex, previous_lgib_admission, dre_blood, heart_rate,
                   systolic_bp, hemoglobin, hemoglobin_units = "g/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<40: 0 pts.
40-69: 0 pts.
70-79: 1 pt.
>=80: 2 pts.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). Male adds 1 point.
}
  \item{previous_lgib_admission}{
Numeric (0 or 1). History of previous admission for lower GI bleed. (1 = Yes, +1 pt).
}
  \item{dre_blood}{
Numeric (0 or 1). Blood present on digital rectal examination. (1 = Yes, +1 pt).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
<70: 0 pts.
70-89: 1 pt.
90-109: 2 pts.
>=110: 3 pts.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
<90: 5 pts.
90-119: 4 pts.
120-129: 3 pts.
130-159: 2 pts.
>=160: 0 pts.
}
  \item{hemoglobin}{
Numeric. Hemoglobin level.
}
  \item{hemoglobin_units}{
String. Units for hemoglobin input. Options: "g/dL" (default), "g/L", or "mmol/L".
Scoring (g/L equivalent):
<70: 22 pts.
70-89: 17 pts.
90-109: 13 pts.
110-129: 8 pts.
130-159: 4 pts.
>=160: 0 pts.
}
}
\value{
A list containing:
\item{Oakland_Score}{The calculated total score (Range 0-35+).}
\item{Recommendation}{Guidance on discharge vs. admission based on the cutoff of 8.}
\item{Probability_Safe_Discharge}{Estimated probability of safe outcome.}
}
\references{
Oakland K, Jairath V, Uberoi R, et al. Derivation and validation of a novel risk score for safe discharge after acute lower gastrointestinal bleeding. Gut. 2017;66(4):635-643. doi:10.1136/gutjnl-2015-311005
}
\examples{

# Example 1: Low Risk (Safe Discharge)
# 45yo Female (0), No prev admit (0), No DRE blood (0), HR 65 (0), SBP 140 (2), Hb 14 (4)
# Score = 0 + 0 + 0 + 0 + 0 + 2 + 4 = 6
oakland_score_lgib(45, "female", 0, 0, 65, 140, 14.0)

# Example 2: High Risk (Admission)
# 75yo Male (1+1), Prev Admit (1), DRE Blood (1), HR 100 (2), SBP 100 (4), Hb 10 (13)
# Score = 1 + 1 + 1 + 1 + 2 + 4 + 13 = 23
oakland_score_lgib(75, "male", 1, 1, 100, 100, 10.0)
}
