\name{pecarn_c_spine_rule}
\alias{pecarn_c_spine_rule}
\title{
PECARN Pediatric Cervical Spine Injury Risk Score
}
\description{
Applies the PECARN decision rule to identify children at very low risk of clinically important cervical spine injury (CSI) after blunt trauma. The rule stratifies patients into High Risk (requiring CT), Intermediate Risk (requiring plain films or observation), and Low Risk (no imaging needed).
}
\usage{
pecarn_c_spine_rule(gcs_score, altered_mental_status, focal_neurologic_deficit,
                    neck_pain, torticollis, substantial_torso_injury,
                    predisposing_condition, high_risk_mechanism)
}
\arguments{
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score (3-15). (GCS < 15 is a high-risk factor).
}
  \item{altered_mental_status}{
Numeric (0 or 1). Presence of altered mental status (agitation, somnolence, repetitive questioning, or slow response to verbal questioning). (1 = Yes).
}
  \item{focal_neurologic_deficit}{
Numeric (0 or 1). Presence of focal neurologic deficit. (1 = Yes).
}
  \item{neck_pain}{
Numeric (0 or 1). Patient complains of neck pain. (1 = Yes).
}
  \item{torticollis}{
Numeric (0 or 1). Presence of torticollis (wry neck/stiff neck). (1 = Yes).
}
  \item{substantial_torso_injury}{
Numeric (0 or 1). Presence of substantial torso injury (e.g., seatbelt sign, chest/abdominal tenderness, or deformities). (1 = Yes).
}
  \item{predisposing_condition}{
Numeric (0 or 1). Presence of conditions predisposing to CSI (e.g., Trisomy 21, collagen vascular disease, prior cervical spine surgery/abnormality). (1 = Yes).
}
  \item{high_risk_mechanism}{
Numeric (0 or 1). High-risk mechanism of injury (e.g., diving, MVC, fall > 10ft/3m, axial load). (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Level}{Classification (High Risk, Intermediate Risk, Low Risk).}
\item{Recommendation}{Imaging guidance based on the risk level.}
}
\references{
Leonard JC, Kuppermann N, Olsen C, et al. Factors associated with cervical spine injury in children after blunt trauma. Ann Emerg Med. 2011;58(2):145-155. doi:10.1016/j.annemergmed.2010.08.038
}
\examples{

# Example 1: High Risk (GCS 14)
pecarn_c_spine_rule(14, 0, 0, 0, 0, 0, 0, 1)

# Example 2: Intermediate Risk (Neck Pain only)
pecarn_c_spine_rule(15, 0, 0, 1, 0, 0, 0, 0)

# Example 3: Low Risk (No factors)
pecarn_c_spine_rule(15, 0, 0, 0, 0, 0, 0, 0)
}
