\name{pediatric_big_score}
\alias{pediatric_big_score}
\title{
Pediatric Trauma BIG Score
}
\description{
Calculates the BIG Score (Base deficit, INR, Glasgow coma scale) to predict in-hospital mortality in pediatric trauma patients. This rapid stratification tool uses admission laboratory and clinical values to identify children with a high risk of death.
}
\usage{
pediatric_big_score(base_deficit, inr, gcs)
}
\arguments{
  \item{base_deficit}{
Numeric. Admission base deficit in mmol/L (or mEq/L). Enter as a positive value representing the deficit (e.g., if Base Excess is -10, enter 10).
}
  \item{inr}{
Numeric. Admission International Normalized Ratio.
}
  \item{gcs}{
Numeric. Admission Glasgow Coma Scale score (3-15).
}
}
\value{
A list containing:
\item{BIG_Score}{The calculated score.}
\item{Risk_Category}{Risk stratification based on the threshold of 16.}
\item{Mortality_Prediction}{Estimated mortality risk category.}
}
\references{
Borgman MA, Maegele M, Spinella PC, et al. Patient-specific predictive model for in-hospital mortality in children with traumatic injuries. Pediatrics. 2011;127(3):e689-696. doi:10.1542/peds.2010-1257
}
\examples{

# Example 1: Low Risk
# Base Deficit 2, INR 1.1, GCS 15
# Score = 2 + (2.5 * 1.1) + (15 - 15) = 2 + 2.75 + 0 = 4.75
pediatric_big_score(2, 1.1, 15)

# Example 2: High Risk
# Base Deficit 10, INR 1.8, GCS 8
# Score = 10 + (2.5 * 1.8) + (15 - 8) = 10 + 4.5 + 7 = 21.5
pediatric_big_score(10, 1.8, 8)
}
