\name{pediatric_sepsis_criteria}
\alias{pediatric_sepsis_criteria}
\title{
Pediatric SIRS, Sepsis, and Septic Shock Criteria
}
\description{
Evaluates the 2005 International Pediatric Sepsis Consensus Conference criteria for SIRS, Sepsis, Severe Sepsis, and Septic Shock. The calculation uses age-specific thresholds for heart rate, respiratory rate, and leukocyte count.
}
\usage{
pediatric_sepsis_criteria(age_category, temp_c, heart_rate, respiratory_rate,
                          wbc_count, bands_percent, infection_suspected,
                          cardiovascular_dysfunction, ards_present,
                          multiple_organ_dysfunction)
}
\arguments{
  \item{age_category}{
String. One of: "newborn_0_7d", "neonate_1w_1m", "infant_1m_1y", "child_2y_5y", "child_6y_12y", "adolescent_13y_18y".
}
  \item{temp_c}{
Numeric. Core temperature in degrees Celsius. (Abnormal: >38.5 or <36.0).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{wbc_count}{
Numeric. White Blood Cell count in x10^3/mm^3.
}
  \item{bands_percent}{
Numeric. Percentage of immature neutrophils (bands). (Abnormal: >10\%).
}
  \item{infection_suspected}{
Numeric (0 or 1). Is there a suspected or proven infection? (1 = Yes).
}
  \item{cardiovascular_dysfunction}{
Numeric (0 or 1). Presence of cardiovascular dysfunction (e.g., hypotension, need for vasoactive drug, prolonged capillary refill). (1 = Yes).
}
  \item{ards_present}{
Numeric (0 or 1). Presence of Acute Respiratory Distress Syndrome (ARDS). (1 = Yes).
}
  \item{multiple_organ_dysfunction}{
Numeric (0 or 1). Presence of two or more other organ dysfunctions (respiratory, renal, neurologic, hematologic, hepatic). (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{The highest severity classification met (No SIRS, SIRS, Sepsis, Severe Sepsis, or Septic Shock).}
\item{Detailed_Results}{Boolean values for each classification level.}
\item{Criteria_Met}{Boolean values indicating which specific SIRS physiological criteria were abnormal.}
}
\references{
Goldstein B, Giroir B, Randolph A; International Consensus Conference on Pediatric Sepsis. International pediatric sepsis consensus conference: definitions for sepsis and organ dysfunction in pediatrics. Pediatr Crit Care Med. 2005;6(1):2-8. doi:10.1097/01.PCC.0000149131.72248.E6
}
\examples{

# Example 1: Septic Shock
# Child 3y, High HR, High WBC, Infection, CV dysfunction
pediatric_sepsis_criteria("child_2y_5y", 39.0, 150, 20, 16, 0, 1, 1, 0, 0)

# Example 2: SIRS only
# Adolescent, Fever, Tachycardia, No infection
pediatric_sepsis_criteria("adolescent_13y_18y", 39.0, 120, 14, 8, 0, 0, 0, 0, 0)
}
